
package com.sabre.webservices.triprecord;

import java.io.Serializable;

/** 
 * List of possible Retry record statuses

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://webservices.sabre.com/triprecord" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RetryRecordStatus">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="NEW"/>
 *     &lt;xs:enumeration value="IN_PROGRESS"/>
 *     &lt;xs:enumeration value="COMPLETED"/>
 *     &lt;xs:enumeration value="FAILED"/>
 *     &lt;xs:enumeration value="POST_PROCESSING_NEEDED"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum RetryRecordStatus implements Serializable {
    NEW, IN_PROGRESS, COMPLETED, FAILED, POST_PROCESSING_NEEDED
}
