
package com.sabre.webservices.triprecord;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/triprecord" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TripSummaryType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Trip" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Trip -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Content">
 *       &lt;xs:complexType>
 *         &lt;xs:choice>
 *           &lt;xs:any processContents="lax"/>
 *         &lt;/xs:choice>
 *         &lt;xs:anyAttribute processContents="lax" namespace="##local"/>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TripSummaryType implements Serializable
{
    private List<Trip> tripList = new ArrayList<Trip>();
    private Element content;

    /** 
     * Get the list of 'Trip' element items.
     * 
     * @return list
     */
    public List<Trip> getTripList() {
        return tripList;
    }

    /** 
     * Set the list of 'Trip' element items.
     * 
     * @param list
     */
    public void setTripList(List<Trip> list) {
        tripList = list;
    }

    /** 
     * Get the 'Content' element value.
     * 
     * @return value
     */
    public Element getContent() {
        return content;
    }

    /** 
     * Set the 'Content' element value.
     * 
     * @param content
     */
    public void setContent(Element content) {
        this.content = content;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/triprecord" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Trip" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:TripIDType">
     *         &lt;xs:sequence>
     *           &lt;xs:element name="Components" minOccurs="0">
     *             &lt;!-- Reference to inner class Components -->
     *           &lt;/xs:element>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Trip extends TripIDType implements Serializable
    {
        private Components components;

        /** 
         * Get the 'Components' element value.
         * 
         * @return value
         */
        public Components getComponents() {
            return components;
        }

        /** 
         * Set the 'Components' element value.
         * 
         * @param components
         */
        public void setComponents(Components components) {
            this.components = components;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/triprecord" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Components" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:ComponentIDType" name="ComponentID" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Components implements Serializable
        {
            private List<ComponentIDType> componentIDList = new ArrayList<ComponentIDType>();

            /** 
             * Get the list of 'ComponentID' element items.
             * 
             * @return list
             */
            public List<ComponentIDType> getComponentIDList() {
                return componentIDList;
            }

            /** 
             * Set the list of 'ComponentID' element items.
             * 
             * @param list
             */
            public void setComponentIDList(List<ComponentIDType> list) {
                componentIDList = list;
            }
        }
    }
}
