
package com.sabre.webservices.triprecord;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://webservices.sabre.com/triprecord" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="UpdateActions">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Add"/>
 *     &lt;xs:enumeration value="Update"/>
 *     &lt;xs:enumeration value="Delete"/>
 *     &lt;xs:enumeration value="None"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum UpdateActions implements Serializable {
    ADD("Add"), UPDATE("Update"), DELETE("Delete"), NONE("None");
    private final String value;

    private UpdateActions(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static UpdateActions convert(String value) {
        for (UpdateActions inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
