
package org.ebxml.namespaces.messageheader;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.ebxml.org/namespaces/messageHeader" xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Acknowledgment">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:Timestamp"/>
 *       &lt;xs:element ref="ns:RefToMessageId"/>
 *       &lt;xs:element ref="ns:From" minOccurs="0"/>
 *       &lt;xs:element ref="ns:Reference" minOccurs="0" maxOccurs="unbounded"/>
 *       &lt;xs:any minOccurs="0" maxOccurs="unbounded" processContents="lax" namespace="##other"/>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:headerExtension.grp"/>
 *     &lt;xs:attribute ref="soap:actor">
 *       &lt;!-- Reference to inner class Actor -->
 *     &lt;/xs:attribute>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class Acknowledgment implements Serializable
{
    private Timestamp timestamp;
    private RefToMessageId refToMessageId;
    private From from;
    private List<Reference> referenceList = new ArrayList<Reference>();
    private List<Element> anyList = new ArrayList<Element>();
    private HeaderExtensionGrp headerExtensionGrp;
    private Actor actor;

    /** 
     * Get the 'Timestamp' element value.
     * 
     * @return value
     */
    public Timestamp getTimestamp() {
        return timestamp;
    }

    /** 
     * Set the 'Timestamp' element value.
     * 
     * @param timestamp
     */
    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    /** 
     * Get the 'RefToMessageId' element value.
     * 
     * @return value
     */
    public RefToMessageId getRefToMessageId() {
        return refToMessageId;
    }

    /** 
     * Set the 'RefToMessageId' element value.
     * 
     * @param refToMessageId
     */
    public void setRefToMessageId(RefToMessageId refToMessageId) {
        this.refToMessageId = refToMessageId;
    }

    /** 
     * Get the 'From' element value.
     * 
     * @return value
     */
    public From getFrom() {
        return from;
    }

    /** 
     * Set the 'From' element value.
     * 
     * @param from
     */
    public void setFrom(From from) {
        this.from = from;
    }

    /** 
     * Get the list of 'Reference' element items.
     * 
     * @return list
     */
    public List<Reference> getReferenceList() {
        return referenceList;
    }

    /** 
     * Set the list of 'Reference' element items.
     * 
     * @param list
     */
    public void setReferenceList(List<Reference> list) {
        referenceList = list;
    }

    /** 
     * Get the list of any items.
     * 
     * @return list
     */
    public List<Element> getAnyList() {
        return anyList;
    }

    /** 
     * Set the list of any items.
     * 
     * @param list
     */
    public void setAnyList(List<Element> list) {
        anyList = list;
    }

    /** 
     * Get the 'headerExtension.grp' attributeGroup value.
     * 
     * @return value
     */
    public HeaderExtensionGrp getHeaderExtensionGrp() {
        return headerExtensionGrp;
    }

    /** 
     * Set the 'headerExtension.grp' attributeGroup value.
     * 
     * @param headerExtensionGrp
     */
    public void setHeaderExtensionGrp(HeaderExtensionGrp headerExtensionGrp) {
        this.headerExtensionGrp = headerExtensionGrp;
    }

    /** 
     * Get the 'actor' attribute value.
     * 
     * @return value
     */
    public Actor getActor() {
        return actor;
    }

    /** 
     * Set the 'actor' attribute value.
     * 
     * @param actor
     */
    public void setActor(Actor actor) {
        this.actor = actor;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:attribute xmlns:ns="http://schemas.xmlsoap.org/soap/envelope/" xmlns:xs="http://www.w3.org/2001/XMLSchema" ref="ns:actor"/>
     * 
     * &lt;xs:attribute xmlns:ns="http://schemas.xmlsoap.org/soap/envelope/" xmlns:xs="http://www.w3.org/2001/XMLSchema" type="xs:string" name="actor"/>
     * </pre>
     */
    public static class Actor implements Serializable
    {
        private String actor;

        /** 
         * Get the 'actor' attribute value.
         * 
         * @return value
         */
        public String getActor() {
            return actor;
        }

        /** 
         * Set the 'actor' attribute value.
         * 
         * @param actor
         */
        public void setActor(String actor) {
            this.actor = actor;
        }
    }
}
