
package org.ebxml.namespaces.messageheader;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.ebxml.org/namespaces/messageHeader" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MessageOrder">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:SequenceNumber"/>
 *       &lt;xs:any minOccurs="0" maxOccurs="unbounded" processContents="lax" namespace="##other"/>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:headerExtension.grp"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class MessageOrder implements Serializable
{
    private SequenceNumberType sequenceNumber;
    private List<Element> anyList = new ArrayList<Element>();
    private HeaderExtensionGrp headerExtensionGrp;

    /** 
     * Get the 'SequenceNumber' element value.
     * 
     * @return value
     */
    public SequenceNumberType getSequenceNumber() {
        return sequenceNumber;
    }

    /** 
     * Set the 'SequenceNumber' element value.
     * 
     * @param sequenceNumber
     */
    public void setSequenceNumber(SequenceNumberType sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    /** 
     * Get the list of any items.
     * 
     * @return list
     */
    public List<Element> getAnyList() {
        return anyList;
    }

    /** 
     * Set the list of any items.
     * 
     * @param list
     */
    public void setAnyList(List<Element> list) {
        anyList = list;
    }

    /** 
     * Get the 'headerExtension.grp' attributeGroup value.
     * 
     * @return value
     */
    public HeaderExtensionGrp getHeaderExtensionGrp() {
        return headerExtensionGrp;
    }

    /** 
     * Set the 'headerExtension.grp' attributeGroup value.
     * 
     * @param headerExtensionGrp
     */
    public void setHeaderExtensionGrp(HeaderExtensionGrp headerExtensionGrp) {
        this.headerExtensionGrp = headerExtensionGrp;
    }
}
