
package org.ebxml.namespaces.messageheader;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.ebxml.org/namespaces/messageHeader" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="messageStatus.type">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="UnAuthorized"/>
 *     &lt;xs:enumeration value="NotRecognized"/>
 *     &lt;xs:enumeration value="Received"/>
 *     &lt;xs:enumeration value="Processed"/>
 *     &lt;xs:enumeration value="Forwarded"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum MessageStatusType implements Serializable {
    UN_AUTHORIZED("UnAuthorized"), NOT_RECOGNIZED("NotRecognized"), RECEIVED(
            "Received"), PROCESSED("Processed"), FORWARDED("Forwarded");
    private final String value;

    private MessageStatusType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static MessageStatusType convert(String value) {
        for (MessageStatusType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
