
package org.ebxml.namespaces.messageheader;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.ebxml.org/namespaces/messageHeader" xmlns:ns1="http://schemas.xmlsoap.org/soap/envelope/" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SyncReply">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:any minOccurs="0" maxOccurs="unbounded" processContents="lax" namespace="##other"/>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:headerExtension.grp"/>
 *     &lt;xs:attribute use="required" ref="ns1:actor"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * 
 * &lt;xs:attribute xmlns:ns="http://www.ebxml.org/namespaces/messageHeader" xmlns:ns1="http://schemas.xmlsoap.org/soap/envelope/" xmlns:xs="http://www.w3.org/2001/XMLSchema" type="xs:string" name="actor"/>
 * </pre>
 */
public class SyncReply implements Serializable
{
    private List<Element> anyList = new ArrayList<Element>();
    private HeaderExtensionGrp headerExtensionGrp;
    private String actor;

    /** 
     * Get the list of any items.
     * 
     * @return list
     */
    public List<Element> getAnyList() {
        return anyList;
    }

    /** 
     * Set the list of any items.
     * 
     * @param list
     */
    public void setAnyList(List<Element> list) {
        anyList = list;
    }

    /** 
     * Get the 'headerExtension.grp' attributeGroup value.
     * 
     * @return value
     */
    public HeaderExtensionGrp getHeaderExtensionGrp() {
        return headerExtensionGrp;
    }

    /** 
     * Set the 'headerExtension.grp' attributeGroup value.
     * 
     * @param headerExtensionGrp
     */
    public void setHeaderExtensionGrp(HeaderExtensionGrp headerExtensionGrp) {
        this.headerExtensionGrp = headerExtensionGrp;
    }

    /** 
     * Get the 'actor' attribute value.
     * 
     * @return value
     */
    public String getActor() {
        return actor;
    }

    /** 
     * Set the 'actor' attribute value.
     * 
     * @param actor
     */
    public void setActor(String actor) {
        this.actor = actor;
    }
}
