
package org.opentravel.common.v02;

import java.io.Serializable;

/** 
 * Metadata that describes a codelist.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://opentravel.org/common/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CodeList">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="ns:Enum_CodelistSource_Base">
 *       &lt;xs:attribute type="xs:string" name="extension"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="itemCode"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="itemName"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="listNameCode"/>
 *       &lt;xs:attribute type="ns:Enum_OpenTravelCodelist" use="optional" name="openTravelListName"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="otherListName"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CodeList implements Serializable
{
    private EnumCodelistSourceBase enumCodelistSourceBase;
    private String extension;
    private String itemCode;
    private String itemName;
    private String listNameCode;
    private EnumOpenTravelCodelist openTravelListName;
    private String otherListName;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public EnumCodelistSourceBase getEnumCodelistSourceBase() {
        return enumCodelistSourceBase;
    }

    /** 
     * Set the extension value.
     * 
     * @param enumCodelistSourceBase
     */
    public void setEnumCodelistSourceBase(
            EnumCodelistSourceBase enumCodelistSourceBase) {
        this.enumCodelistSourceBase = enumCodelistSourceBase;
    }

    /** 
     * Get the 'extension' attribute value.
     * 
     * @return value
     */
    public String getExtension() {
        return extension;
    }

    /** 
     * Set the 'extension' attribute value.
     * 
     * @param extension
     */
    public void setExtension(String extension) {
        this.extension = extension;
    }

    /** 
     * Get the 'itemCode' attribute value. The numeric ID or code for the value from the code list.
     * 
     * @return value
     */
    public String getItemCode() {
        return itemCode;
    }

    /** 
     * Set the 'itemCode' attribute value. The numeric ID or code for the value from the code list.
     * 
     * @param itemCode
     */
    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    /** 
     * Get the 'itemName' attribute value. The literal (textual) value from the code list.
     * 
     * @return value
     */
    public String getItemName() {
        return itemName;
    }

    /** 
     * Set the 'itemName' attribute value. The literal (textual) value from the code list.
     * 
     * @param itemName
     */
    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    /** 
     * Get the 'listNameCode' attribute value. The acronym or code for the code list name.
     * 
     * @return value
     */
    public String getListNameCode() {
        return listNameCode;
    }

    /** 
     * Set the 'listNameCode' attribute value. The acronym or code for the code list name.
     * 
     * @param listNameCode
     */
    public void setListNameCode(String listNameCode) {
        this.listNameCode = listNameCode;
    }

    /** 
     * Get the 'openTravelListName' attribute value. The OpenTravel code list name.
     * 
     * @return value
     */
    public EnumOpenTravelCodelist getOpenTravelListName() {
        return openTravelListName;
    }

    /** 
     * Set the 'openTravelListName' attribute value. The OpenTravel code list name.
     * 
     * @param openTravelListName
     */
    public void setOpenTravelListName(EnumOpenTravelCodelist openTravelListName) {
        this.openTravelListName = openTravelListName;
    }

    /** 
     * Get the 'otherListName' attribute value. The name of a third party (non-OpenTravel) code list.
     * 
     * @return value
     */
    public String getOtherListName() {
        return otherListName;
    }

    /** 
     * Set the 'otherListName' attribute value. The name of a third party (non-OpenTravel) code list.
     * 
     * @param otherListName
     */
    public void setOtherListName(String otherListName) {
        this.otherListName = otherListName;
    }
}
