
package org.opentravel.common.v02;

import java.io.Serializable;

/** 
 * Detail data policy information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://opentravel.org/common/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DataPolicy_Detail">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:DataPolicy">
 *       &lt;xs:attribute type="xs:string" use="optional" name="description"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="url"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DataPolicyDetail extends DataPolicy1 implements Serializable
{
    private String description;
    private String url;

    /** 
     * Get the 'description' attribute value. A brief description of the data policy intended to be used for logging and
                              compliance purposes.
                          
     * 
     * @return value
     */
    public String getDescription() {
        return description;
    }

    /** 
     * Set the 'description' attribute value. A brief description of the data policy intended to be used for logging and
                              compliance purposes.
                          
     * 
     * @param description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /** 
     * Get the 'url' attribute value. A URL to a source that describes the data policy.
     * 
     * @return value
     */
    public String getUrl() {
        return url;
    }

    /** 
     * Set the 'url' attribute value. A URL to a source that describes the data policy.
     * 
     * @param url
     */
    public void setUrl(String url) {
        this.url = url;
    }
}
