
package org.opentravel.common.v02;

import java.io.Serializable;

/** 
 * An extensible list of identifiers for a type of data usage policy and/or restriction.
 Note that any data use, sharing or retention policies MUST be agreed upon by trading
 partners. Exchanging a warning and/or data restriction policy content in an electronic message does indicate policy
 compliance awareness by the receiving party. This functionality is typically used for privacy compliance and log auditing
 purposes only.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://opentravel.org/common/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enum_DataPolicyType_Base">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Retention"/>
 *     &lt;xs:enumeration value="Sharing"/>
 *     &lt;xs:enumeration value="Use"/>
 *     &lt;xs:enumeration value="Retention, Sharing and Use"/>
 *     &lt;xs:enumeration value="Other_"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumDataPolicyTypeBase implements Serializable {
    /** 
     * Indicates the encrypted information is subject to a data retention (data
    storage) policy established by the sending party and known to recipient parties.
    
     */
    RETENTION("Retention"), /** 
                             * Indicates the encrypted information is subject to a data sharing policy
                            (internal and third party) established by the sending party and known to recipient parties.
                            
                             */
    SHARING("Sharing"), /** 
                         * Indicates the encrypted information is subject to a data use policy (internal
                            and third party) established by the sending party and known to recipient parties.
                        
                         */
    USE("Use"), /** 
                 * Indicates the encrypted information is subject to a data retention, sharing and
                            use policy established by the sending party and known to recipient parties.
                        
                 */
    RETENTION_SHARINGAND_USE("Retention, Sharing and Use"), OTHER_("Other_");
    private final String value;

    private EnumDataPolicyTypeBase(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumDataPolicyTypeBase convert(String value) {
        for (EnumDataPolicyTypeBase inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
