
package org.opentravel.common.v02;

import java.io.Serializable;

/** 
 * OpenTravel codelist table names.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://opentravel.org/common/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enum_OpenTravelCodelist">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="ADT:Additional Detail Type"/>
 *     &lt;xs:enumeration value="OPR:Additional Operation Info"/>
 *     &lt;xs:enumeration value="AUT:Address Use Type"/>
 *     &lt;xs:enumeration value="AQC:Age Qualifying Code"/>
 *     &lt;xs:enumeration value="ROW:Air Row Type"/>
 *     &lt;xs:enumeration value="AST:Air Seat Type"/>
 *     &lt;xs:enumeration value="ARC:Architectural Style Code"/>
 *     &lt;xs:enumeration value="ACC:Attraction Category Code"/>
 *     &lt;xs:enumeration value="AMC:Available Meal Category Codes"/>
 *     &lt;xs:enumeration value="BED:Bed Type"/>
 *     &lt;xs:enumeration value="BEV:Beverage Code"/>
 *     &lt;xs:enumeration value="BCT:Booking Channel Type"/>
 *     &lt;xs:enumeration value="BIL:Booking Information List"/>
 *     &lt;xs:enumeration value="BUS:Business Srvc Type"/>
 *     &lt;xs:enumeration value="CBF:Cabin Filters"/>
 *     &lt;xs:enumeration value="CDT:Card Type"/>
 *     &lt;xs:enumeration value="CQC:Category Qualifier Code"/>
 *     &lt;xs:enumeration value="CHG:Charge Type"/>
 *     &lt;xs:enumeration value="CLT:Communication Location Type"/>
 *     &lt;xs:enumeration value="CON:Contact Location"/>
 *     &lt;xs:enumeration value="CSC:Contact Srvc Code"/>
 *     &lt;xs:enumeration value="CTT:Content Code"/>
 *     &lt;xs:enumeration value="CFC:Content Format Code"/>
 *     &lt;xs:enumeration value="CNT:Count Category"/>
 *     &lt;xs:enumeration value="COV:Coverage Type"/>
 *     &lt;xs:enumeration value="CRD:Cruise Document Type"/>
 *     &lt;xs:enumeration value="CPK:Cruise Package Code"/>
 *     &lt;xs:enumeration value="CPT:Cruise Profile Type"/>
 *     &lt;xs:enumeration value="DEC:Decline Reason"/>
 *     &lt;xs:enumeration value="DSP:Destination Service Provider Type"/>
 *     &lt;xs:enumeration value="DIS:Discounts Available"/>
 *     &lt;xs:enumeration value="DTB:Distribution Type"/>
 *     &lt;xs:enumeration value="DOC:Document Type"/>
 *     &lt;xs:enumeration value="EAT:Email Address Type"/>
 *     &lt;xs:enumeration value="EAC:EMD Application Code"/>
 *     &lt;xs:enumeration value="ECF:EMD Carrier Fee Type"/>
 *     &lt;xs:enumeration value="ECT:EMD Commission Type"/>
 *     &lt;xs:enumeration value="ERI:EMD Reason For Issuance"/>
 *     &lt;xs:enumeration value="ETM:EMD Ticketing Mode"/>
 *     &lt;xs:enumeration value="EMP:Employee Status"/>
 *     &lt;xs:enumeration value="ENR:Enrollment Method"/>
 *     &lt;xs:enumeration value="EQP:Equipment Type"/>
 *     &lt;xs:enumeration value="EWT:Error Warning Type"/>
 *     &lt;xs:enumeration value="EVT:Event Charge"/>
 *     &lt;xs:enumeration value="ETT:Event Type"/>
 *     &lt;xs:enumeration value="EXH:Exhibit Type"/>
 *     &lt;xs:enumeration value="FAQ:Fare Qualifier"/>
 *     &lt;xs:enumeration value="FAR:Fare Restriction"/>
 *     &lt;xs:enumeration value="FTT:Fee Tax Type"/>
 *     &lt;xs:enumeration value="FDC:Flight Delay Code"/>
 *     &lt;xs:enumeration value="FSC:Flight Service Code"/>
 *     &lt;xs:enumeration value="FMT:Format Type"/>
 *     &lt;xs:enumeration value="GRI:Guest Room Info"/>
 *     &lt;xs:enumeration value="HAC:Hotel Amenity Code"/>
 *     &lt;xs:enumeration value="GUE:Hotel Guest Type"/>
 *     &lt;xs:enumeration value="HIC:Hotel Information Code"/>
 *     &lt;xs:enumeration value="HST:Hotel Status Code"/>
 *     &lt;xs:enumeration value="IPC:Index Point Code"/>
 *     &lt;xs:enumeration value="ITR:Information To Return"/>
 *     &lt;xs:enumeration value="INF:Information Type"/>
 *     &lt;xs:enumeration value="IBT:Inventory Block Type"/>
 *     &lt;xs:enumeration value="LOS:Level of Service"/>
 *     &lt;xs:enumeration value="IBS:Inventory Block Status"/>
 *     &lt;xs:enumeration value="INV:Inventory Count Type"/>
 *     &lt;xs:enumeration value=":PAYMENT CARD ISSUER"/>
 *     &lt;xs:enumeration value=":Credit Card Category"/>
 *     &lt;xs:enumeration value="KDF:Key Decision Factors"/>
 *     &lt;xs:enumeration value="LTC:Link Type Code"/>
 *     &lt;xs:enumeration value="LOC:Location Category Codes"/>
 *     &lt;xs:enumeration value="CUI:Main Cuisine Code"/>
 *     &lt;xs:enumeration value="MPT:Meal Plan Type"/>
 *     &lt;xs:enumeration value="MRC:Meeting Room Code"/>
 *     &lt;xs:enumeration value="MRF:Meeting Room Format Code"/>
 *     &lt;xs:enumeration value="MCC:Message Content Code"/>
 *     &lt;xs:enumeration value="MTC:Misc Ticketing Code"/>
 *     &lt;xs:enumeration value="MOD:Modification Type"/>
 *     &lt;xs:enumeration value="NAM:Name Type"/>
 *     &lt;xs:enumeration value="OTC:Option Type Code"/>
 *     &lt;xs:enumeration value="OTT:Other Time Type"/>
 *     &lt;xs:enumeration value="PKG:Package Type"/>
 *     &lt;xs:enumeration value="PKO:Package Option Type"/>
 *     &lt;xs:enumeration value="PLC:Participation Level"/>
 *     &lt;xs:enumeration value="PMT:Payment Type"/>
 *     &lt;xs:enumeration value="PET:Pets Policy Code"/>
 *     &lt;xs:enumeration value="PLT:Phone Location Type"/>
 *     &lt;xs:enumeration value="PTT:Phone Technology Type"/>
 *     &lt;xs:enumeration value="PUT:Phone Use Type"/>
 *     &lt;xs:enumeration value="PHY:Disability Feature Code"/>
 *     &lt;xs:enumeration value="PIC:Picture Category Code"/>
 *     &lt;xs:enumeration value="PAC:Position Accuracy"/>
 *     &lt;xs:enumeration value="PPC:Pricing Processing Code"/>
 *     &lt;xs:enumeration value="PQC:Pricing Qualifier Code"/>
 *     &lt;xs:enumeration value="PRI:Price Type Code"/>
 *     &lt;xs:enumeration value="PST:Profile Status"/>
 *     &lt;xs:enumeration value="PRT:Profile Type"/>
 *     &lt;xs:enumeration value="PCT:Property Class Type"/>
 *     &lt;xs:enumeration value="PRX:Proximity"/>
 *     &lt;xs:enumeration value="QCC:Question Category"/>
 *     &lt;xs:enumeration value="QST:Question Type"/>
 *     &lt;xs:enumeration value="RAT:Rail Amenity Type"/>
 *     &lt;xs:enumeration value="RAN:Rail Ancillary Services"/>
 *     &lt;xs:enumeration value="PXC:Rail Passenger Type Code"/>
 *     &lt;xs:enumeration value="RTC:Rate Category"/>
 *     &lt;xs:enumeration value="RMO:Rate Mode"/>
 *     &lt;xs:enumeration value="RPT:Rate Plan Type"/>
 *     &lt;xs:enumeration value="RST:Recreation Srvc Type"/>
 *     &lt;xs:enumeration value="REC:Recreation Srvc Detail Code"/>
 *     &lt;xs:enumeration value="REF:Reference Point Category Code"/>
 *     &lt;xs:enumeration value="REL:Relationship"/>
 *     &lt;xs:enumeration value="RAC:Rental Action Code"/>
 *     &lt;xs:enumeration value="RQC:Requested Info Code"/>
 *     &lt;xs:enumeration value="RBT:Reservation Billing Type"/>
 *     &lt;xs:enumeration value="RBD:Res Book Designator Status Code"/>
 *     &lt;xs:enumeration value="RMC:Reservation Method Code"/>
 *     &lt;xs:enumeration value="RES:Restaurant Category Code"/>
 *     &lt;xs:enumeration value="RPC:Restaurant Policy Code"/>
 *     &lt;xs:enumeration value="RSI:Restaurant Srvc Info"/>
 *     &lt;xs:enumeration value="RCC:Revenue Category Code"/>
 *     &lt;xs:enumeration value="RMA:Room Amenity Type"/>
 *     &lt;xs:enumeration value="RLT:Room Location Type"/>
 *     &lt;xs:enumeration value="RVT:Room View Type"/>
 *     &lt;xs:enumeration value="RUL:Rule Type"/>
 *     &lt;xs:enumeration value="SAI:Sailing Description Code"/>
 *     &lt;xs:enumeration value="SRF:Search Response Filter"/>
 *     &lt;xs:enumeration value="SAV:Seat Availability"/>
 *     &lt;xs:enumeration value="STP:Seat Preference"/>
 *     &lt;xs:enumeration value="SEC:Security Feature Code"/>
 *     &lt;xs:enumeration value="SEG:Segment Category Code"/>
 *     &lt;xs:enumeration value="SIZ:Size"/>
 *     &lt;xs:enumeration value="SOC:Sort Order Code"/>
 *     &lt;xs:enumeration value="SRO:Special Remark Option Type"/>
 *     &lt;xs:enumeration value="SCC:Stat Category Code"/>
 *     &lt;xs:enumeration value="STS:Status"/>
 *     &lt;xs:enumeration value="TRC:Traffic Restriction Code"/>
 *     &lt;xs:enumeration value="TSC:Train Schedule Code"/>
 *     &lt;xs:enumeration value="TTC:Train Type Code"/>
 *     &lt;xs:enumeration value="TMT:Transport Mode Type"/>
 *     &lt;xs:enumeration value="TRP:Transportation Code"/>
 *     &lt;xs:enumeration value="TVP:Travel Purpose"/>
 *     &lt;xs:enumeration value="TVS:Travel Sector"/>
 *     &lt;xs:enumeration value="UIT:Unique Id Type"/>
 *     &lt;xs:enumeration value="UOM:Unit of Measure Code"/>
 *     &lt;xs:enumeration value="USC:Utility Service Code"/>
 *     &lt;xs:enumeration value="VEC:Vehicle Category"/>
 *     &lt;xs:enumeration value="VCP:Vehicle Charge Purpose Type"/>
 *     &lt;xs:enumeration value="VCT:Vehicle Coverage Type"/>
 *     &lt;xs:enumeration value="VLI:Vehicle Location Information Type"/>
 *     &lt;xs:enumeration value="VWF:Vehicle Where At Facility"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumOpenTravelCodelist implements Serializable {
    ADT_ADDITIONAL_DETAIL_TYPE("ADT:Additional Detail Type"), OPR_ADDITIONAL_OPERATION_INFO(
            "OPR:Additional Operation Info"), AUT_ADDRESS_USE_TYPE(
            "AUT:Address Use Type"), AQC_AGE_QUALIFYING_CODE(
            "AQC:Age Qualifying Code"), ROW_AIR_ROW_TYPE("ROW:Air Row Type"), AST_AIR_SEAT_TYPE(
            "AST:Air Seat Type"), ARC_ARCHITECTURAL_STYLE_CODE(
            "ARC:Architectural Style Code"), ACC_ATTRACTION_CATEGORY_CODE(
            "ACC:Attraction Category Code"), AMC_AVAILABLE_MEAL_CATEGORY_CODES(
            "AMC:Available Meal Category Codes"), BED_BED_TYPE("BED:Bed Type"), BEV_BEVERAGE_CODE(
            "BEV:Beverage Code"), BCT_BOOKING_CHANNEL_TYPE(
            "BCT:Booking Channel Type"), BIL_BOOKING_INFORMATION_LIST(
            "BIL:Booking Information List"), BUS_BUSINESS_SRVC_TYPE(
            "BUS:Business Srvc Type"), CBF_CABIN_FILTERS("CBF:Cabin Filters"), CDT_CARD_TYPE(
            "CDT:Card Type"), CQC_CATEGORY_QUALIFIER_CODE(
            "CQC:Category Qualifier Code"), CHG_CHARGE_TYPE("CHG:Charge Type"), CLT_COMMUNICATION_LOCATION_TYPE(
            "CLT:Communication Location Type"), CON_CONTACT_LOCATION(
            "CON:Contact Location"), CSC_CONTACT_SRVC_CODE(
            "CSC:Contact Srvc Code"), CTT_CONTENT_CODE("CTT:Content Code"), CFC_CONTENT_FORMAT_CODE(
            "CFC:Content Format Code"), CNT_COUNT_CATEGORY("CNT:Count Category"), COV_COVERAGE_TYPE(
            "COV:Coverage Type"), CRD_CRUISE_DOCUMENT_TYPE(
            "CRD:Cruise Document Type"), CPK_CRUISE_PACKAGE_CODE(
            "CPK:Cruise Package Code"), CPT_CRUISE_PROFILE_TYPE(
            "CPT:Cruise Profile Type"), DEC_DECLINE_REASON("DEC:Decline Reason"), DSP_DESTINATION_SERVICE_PROVIDER_TYPE(
            "DSP:Destination Service Provider Type"), DIS_DISCOUNTS_AVAILABLE(
            "DIS:Discounts Available"), DTB_DISTRIBUTION_TYPE(
            "DTB:Distribution Type"), DOC_DOCUMENT_TYPE("DOC:Document Type"), EAT_EMAIL_ADDRESS_TYPE(
            "EAT:Email Address Type"), EACEMD_APPLICATION_CODE(
            "EAC:EMD Application Code"), ECFEMD_CARRIER_FEE_TYPE(
            "ECF:EMD Carrier Fee Type"), ECTEMD_COMMISSION_TYPE(
            "ECT:EMD Commission Type"), ERIEMD_REASON_FOR_ISSUANCE(
            "ERI:EMD Reason For Issuance"), ETMEMD_TICKETING_MODE(
            "ETM:EMD Ticketing Mode"), EMP_EMPLOYEE_STATUS(
            "EMP:Employee Status"), ENR_ENROLLMENT_METHOD(
            "ENR:Enrollment Method"), EQP_EQUIPMENT_TYPE("EQP:Equipment Type"), EWT_ERROR_WARNING_TYPE(
            "EWT:Error Warning Type"), EVT_EVENT_CHARGE("EVT:Event Charge"), ETT_EVENT_TYPE(
            "ETT:Event Type"), EXH_EXHIBIT_TYPE("EXH:Exhibit Type"), FAQ_FARE_QUALIFIER(
            "FAQ:Fare Qualifier"), FAR_FARE_RESTRICTION("FAR:Fare Restriction"), FTT_FEE_TAX_TYPE(
            "FTT:Fee Tax Type"), FDC_FLIGHT_DELAY_CODE("FDC:Flight Delay Code"), FSC_FLIGHT_SERVICE_CODE(
            "FSC:Flight Service Code"), FMT_FORMAT_TYPE("FMT:Format Type"), GRI_GUEST_ROOM_INFO(
            "GRI:Guest Room Info"), HAC_HOTEL_AMENITY_CODE(
            "HAC:Hotel Amenity Code"), GUE_HOTEL_GUEST_TYPE(
            "GUE:Hotel Guest Type"), HIC_HOTEL_INFORMATION_CODE(
            "HIC:Hotel Information Code"), HST_HOTEL_STATUS_CODE(
            "HST:Hotel Status Code"), IPC_INDEX_POINT_CODE(
            "IPC:Index Point Code"), ITR_INFORMATION_TO_RETURN(
            "ITR:Information To Return"), INF_INFORMATION_TYPE(
            "INF:Information Type"), IBT_INVENTORY_BLOCK_TYPE(
            "IBT:Inventory Block Type"), LOS_LEVELOF_SERVICE(
            "LOS:Level of Service"), IBS_INVENTORY_BLOCK_STATUS(
            "IBS:Inventory Block Status"), INV_INVENTORY_COUNT_TYPE(
            "INV:Inventory Count Type"), __PAYMENTCARDISSUER(
            ":PAYMENT CARD ISSUER"), __CREDIT_CARD_CATEGORY(
            ":Credit Card Category"), KDF_KEY_DECISION_FACTORS(
            "KDF:Key Decision Factors"), LTC_LINK_TYPE_CODE(
            "LTC:Link Type Code"), LOC_LOCATION_CATEGORY_CODES(
            "LOC:Location Category Codes"), CUI_MAIN_CUISINE_CODE(
            "CUI:Main Cuisine Code"), MPT_MEAL_PLAN_TYPE("MPT:Meal Plan Type"), MRC_MEETING_ROOM_CODE(
            "MRC:Meeting Room Code"), MRF_MEETING_ROOM_FORMAT_CODE(
            "MRF:Meeting Room Format Code"), MCC_MESSAGE_CONTENT_CODE(
            "MCC:Message Content Code"), MTC_MISC_TICKETING_CODE(
            "MTC:Misc Ticketing Code"), MOD_MODIFICATION_TYPE(
            "MOD:Modification Type"), NAM_NAME_TYPE("NAM:Name Type"), OTC_OPTION_TYPE_CODE(
            "OTC:Option Type Code"), OTT_OTHER_TIME_TYPE("OTT:Other Time Type"), PKG_PACKAGE_TYPE(
            "PKG:Package Type"), PKO_PACKAGE_OPTION_TYPE(
            "PKO:Package Option Type"), PLC_PARTICIPATION_LEVEL(
            "PLC:Participation Level"), PMT_PAYMENT_TYPE("PMT:Payment Type"), PET_PETS_POLICY_CODE(
            "PET:Pets Policy Code"), PLT_PHONE_LOCATION_TYPE(
            "PLT:Phone Location Type"), PTT_PHONE_TECHNOLOGY_TYPE(
            "PTT:Phone Technology Type"), PUT_PHONE_USE_TYPE(
            "PUT:Phone Use Type"), PHY_DISABILITY_FEATURE_CODE(
            "PHY:Disability Feature Code"), PIC_PICTURE_CATEGORY_CODE(
            "PIC:Picture Category Code"), PAC_POSITION_ACCURACY(
            "PAC:Position Accuracy"), PPC_PRICING_PROCESSING_CODE(
            "PPC:Pricing Processing Code"), PQC_PRICING_QUALIFIER_CODE(
            "PQC:Pricing Qualifier Code"), PRI_PRICE_TYPE_CODE(
            "PRI:Price Type Code"), PST_PROFILE_STATUS("PST:Profile Status"), PRT_PROFILE_TYPE(
            "PRT:Profile Type"), PCT_PROPERTY_CLASS_TYPE(
            "PCT:Property Class Type"), PRX_PROXIMITY("PRX:Proximity"), QCC_QUESTION_CATEGORY(
            "QCC:Question Category"), QST_QUESTION_TYPE("QST:Question Type"), RAT_RAIL_AMENITY_TYPE(
            "RAT:Rail Amenity Type"), RAN_RAIL_ANCILLARY_SERVICES(
            "RAN:Rail Ancillary Services"), PXC_RAIL_PASSENGER_TYPE_CODE(
            "PXC:Rail Passenger Type Code"), RTC_RATE_CATEGORY(
            "RTC:Rate Category"), RMO_RATE_MODE("RMO:Rate Mode"), RPT_RATE_PLAN_TYPE(
            "RPT:Rate Plan Type"), RST_RECREATION_SRVC_TYPE(
            "RST:Recreation Srvc Type"), REC_RECREATION_SRVC_DETAIL_CODE(
            "REC:Recreation Srvc Detail Code"), REF_REFERENCE_POINT_CATEGORY_CODE(
            "REF:Reference Point Category Code"), REL_RELATIONSHIP(
            "REL:Relationship"), RAC_RENTAL_ACTION_CODE(
            "RAC:Rental Action Code"), RQC_REQUESTED_INFO_CODE(
            "RQC:Requested Info Code"), RBT_RESERVATION_BILLING_TYPE(
            "RBT:Reservation Billing Type"), RBD_RES_BOOK_DESIGNATOR_STATUS_CODE(
            "RBD:Res Book Designator Status Code"), RMC_RESERVATION_METHOD_CODE(
            "RMC:Reservation Method Code"), RES_RESTAURANT_CATEGORY_CODE(
            "RES:Restaurant Category Code"), RPC_RESTAURANT_POLICY_CODE(
            "RPC:Restaurant Policy Code"), RSI_RESTAURANT_SRVC_INFO(
            "RSI:Restaurant Srvc Info"), RCC_REVENUE_CATEGORY_CODE(
            "RCC:Revenue Category Code"), RMA_ROOM_AMENITY_TYPE(
            "RMA:Room Amenity Type"), RLT_ROOM_LOCATION_TYPE(
            "RLT:Room Location Type"), RVT_ROOM_VIEW_TYPE("RVT:Room View Type"), RUL_RULE_TYPE(
            "RUL:Rule Type"), SAI_SAILING_DESCRIPTION_CODE(
            "SAI:Sailing Description Code"), SRF_SEARCH_RESPONSE_FILTER(
            "SRF:Search Response Filter"), SAV_SEAT_AVAILABILITY(
            "SAV:Seat Availability"), STP_SEAT_PREFERENCE("STP:Seat Preference"), SEC_SECURITY_FEATURE_CODE(
            "SEC:Security Feature Code"), SEG_SEGMENT_CATEGORY_CODE(
            "SEG:Segment Category Code"), SIZ_SIZE("SIZ:Size"), SOC_SORT_ORDER_CODE(
            "SOC:Sort Order Code"), SRO_SPECIAL_REMARK_OPTION_TYPE(
            "SRO:Special Remark Option Type"), SCC_STAT_CATEGORY_CODE(
            "SCC:Stat Category Code"), STS_STATUS("STS:Status"), TRC_TRAFFIC_RESTRICTION_CODE(
            "TRC:Traffic Restriction Code"), TSC_TRAIN_SCHEDULE_CODE(
            "TSC:Train Schedule Code"), TTC_TRAIN_TYPE_CODE(
            "TTC:Train Type Code"), TMT_TRANSPORT_MODE_TYPE(
            "TMT:Transport Mode Type"), TRP_TRANSPORTATION_CODE(
            "TRP:Transportation Code"), TVP_TRAVEL_PURPOSE("TVP:Travel Purpose"), TVS_TRAVEL_SECTOR(
            "TVS:Travel Sector"), UIT_UNIQUE_ID_TYPE("UIT:Unique Id Type"), UOM_UNITOF_MEASURE_CODE(
            "UOM:Unit of Measure Code"), USC_UTILITY_SERVICE_CODE(
            "USC:Utility Service Code"), VEC_VEHICLE_CATEGORY(
            "VEC:Vehicle Category"), VCP_VEHICLE_CHARGE_PURPOSE_TYPE(
            "VCP:Vehicle Charge Purpose Type"), VCT_VEHICLE_COVERAGE_TYPE(
            "VCT:Vehicle Coverage Type"), VLI_VEHICLE_LOCATION_INFORMATION_TYPE(
            "VLI:Vehicle Location Information Type"), VWF_VEHICLE_WHERE_AT_FACILITY(
            "VWF:Vehicle Where At Facility");
    private final String value;

    private EnumOpenTravelCodelist(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumOpenTravelCodelist convert(String value) {
        for (EnumOpenTravelCodelist inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
