
package org.opentravel.common.v02;

import java.io.Serializable;

/** 
 * An extensible list of travel industry sector types.Travel Sector (TVS)
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://opentravel.org/common/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enum_TravelSector_Base">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Activity/Attraction/Theme Park"/>
 *     &lt;xs:enumeration value="Airline"/>
 *     &lt;xs:enumeration value="Bed And Breakfast/Hostel"/>
 *     &lt;xs:enumeration value="Car Rental"/>
 *     &lt;xs:enumeration value="Casino"/>
 *     &lt;xs:enumeration value="Convention/Visitor Bureau"/>
 *     &lt;xs:enumeration value="Cruise Line"/>
 *     &lt;xs:enumeration value="Ferry"/>
 *     &lt;xs:enumeration value="Golf"/>
 *     &lt;xs:enumeration value="Ground Transportation: Black Car/Limousine"/>
 *     &lt;xs:enumeration value="Ground Transportation: Bus/Taxi"/>
 *     &lt;xs:enumeration value="Hotel/Resort"/>
 *     &lt;xs:enumeration value="Multi Modal Packages"/>
 *     &lt;xs:enumeration value="Passenger Rail Line"/>
 *     &lt;xs:enumeration value="Restaurant"/>
 *     &lt;xs:enumeration value="Spa"/>
 *     &lt;xs:enumeration value="Tour Operator: Day Tour"/>
 *     &lt;xs:enumeration value="Tour Operator: Package Tour"/>
 *     &lt;xs:enumeration value="Travel Agent"/>
 *     &lt;xs:enumeration value="Travel Market Research Organization"/>
 *     &lt;xs:enumeration value="Travel Insurance"/>
 *     &lt;xs:enumeration value="Travel Media"/>
 *     &lt;xs:enumeration value="Vacation Rental"/>
 *     &lt;xs:enumeration value="Other_"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumTravelSectorBase implements Serializable {
    ACTIVITY_ATTRACTION_THEME_PARK("Activity/Attraction/Theme Park"), AIRLINE(
            "Airline"), BED_AND_BREAKFAST_HOSTEL("Bed And Breakfast/Hostel"), CAR_RENTAL(
            "Car Rental"), CASINO("Casino"), CONVENTION_VISITOR_BUREAU(
            "Convention/Visitor Bureau"), CRUISE_LINE("Cruise Line"), FERRY(
            "Ferry"), GOLF("Golf"), GROUND_TRANSPORTATION_BLACK_CAR_LIMOUSINE(
            "Ground Transportation: Black Car/Limousine"), GROUND_TRANSPORTATION_BUS_TAXI(
            "Ground Transportation: Bus/Taxi"), HOTEL_RESORT("Hotel/Resort"), MULTI_MODAL_PACKAGES(
            "Multi Modal Packages"), PASSENGER_RAIL_LINE("Passenger Rail Line"), RESTAURANT(
            "Restaurant"), SPA("Spa"), TOUR_OPERATOR_DAY_TOUR(
            "Tour Operator: Day Tour"), TOUR_OPERATOR_PACKAGE_TOUR(
            "Tour Operator: Package Tour"), TRAVEL_AGENT("Travel Agent"), TRAVEL_MARKET_RESEARCH_ORGANIZATION(
            "Travel Market Research Organization"), TRAVEL_INSURANCE(
            "Travel Insurance"), TRAVEL_MEDIA("Travel Media"), VACATION_RENTAL(
            "Vacation Rental"), OTHER_("Other_");
    private final String value;

    private EnumTravelSectorBase(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumTravelSectorBase convert(String value) {
        for (EnumTravelSectorBase inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
