
package org.opentravel.common.v02;

import java.io.Serializable;

/** 
 * An extensible list of unique identifier types.Unique ID Type (UIT)
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://opentravel.org/common/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enum_UniqueID_Type_Base">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Acquirer"/>
 *     &lt;xs:enumeration value="Airline"/>
 *     &lt;xs:enumeration value="Alliance"/>
 *     &lt;xs:enumeration value="Associated Itinerary Reservation"/>
 *     &lt;xs:enumeration value="Associated Reservation"/>
 *     &lt;xs:enumeration value="Associated Shared Reservation"/>
 *     &lt;xs:enumeration value="Booking Agent"/>
 *     &lt;xs:enumeration value="Cancellation"/>
 *     &lt;xs:enumeration value="Car Rental"/>
 *     &lt;xs:enumeration value="Child Reference"/>
 *     &lt;xs:enumeration value="Company"/>
 *     &lt;xs:enumeration value="Confirmation Number"/>
 *     &lt;xs:enumeration value="Contract"/>
 *     &lt;xs:enumeration value="Corporation Representative"/>
 *     &lt;xs:enumeration value="CRO (Customer Reservations Office)"/>
 *     &lt;xs:enumeration value="Cruise Line"/>
 *     &lt;xs:enumeration value="Customer"/>
 *     &lt;xs:enumeration value="Divided Reservation"/>
 *     &lt;xs:enumeration value="Distributor"/>
 *     &lt;xs:enumeration value="ERSP (Electronic Reservation Service Provider)"/>
 *     &lt;xs:enumeration value="Fare Quote"/>
 *     &lt;xs:enumeration value="Ground Transportation Supplier"/>
 *     &lt;xs:enumeration value="Group"/>
 *     &lt;xs:enumeration value="Hotel"/>
 *     &lt;xs:enumeration value="Insurance Agency"/>
 *     &lt;xs:enumeration value="Insurance Agent"/>
 *     &lt;xs:enumeration value="Internet Broker"/>
 *     &lt;xs:enumeration value="Linked Reference"/>
 *     &lt;xs:enumeration value="Master Reference"/>
 *     &lt;xs:enumeration value="Meeting Planning Agency"/>
 *     &lt;xs:enumeration value="Merchant"/>
 *     &lt;xs:enumeration value="Parent Reference"/>
 *     &lt;xs:enumeration value="Profile"/>
 *     &lt;xs:enumeration value="Provisional Reservation"/>
 *     &lt;xs:enumeration value="Purged Master Reference"/>
 *     &lt;xs:enumeration value="Reference"/>
 *     &lt;xs:enumeration value="Reissue/Refund Quote"/>
 *     &lt;xs:enumeration value="Reservation"/>
 *     &lt;xs:enumeration value="Ticket"/>
 *     &lt;xs:enumeration value="Tour Operator"/>
 *     &lt;xs:enumeration value="Travel Agency"/>
 *     &lt;xs:enumeration value="Travel Agent PNR"/>
 *     &lt;xs:enumeration value="Wholesaler"/>
 *     &lt;xs:enumeration value="Other_"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumUniqueIDTypeBase implements Serializable {
    ACQUIRER("Acquirer"), AIRLINE("Airline"), ALLIANCE("Alliance"), ASSOCIATED_ITINERARY_RESERVATION(
            "Associated Itinerary Reservation"), ASSOCIATED_RESERVATION(
            "Associated Reservation"), ASSOCIATED_SHARED_RESERVATION(
            "Associated Shared Reservation"), BOOKING_AGENT("Booking Agent"), CANCELLATION(
            "Cancellation"), CAR_RENTAL("Car Rental"), CHILD_REFERENCE(
            "Child Reference"), COMPANY("Company"), CONFIRMATION_NUMBER(
            "Confirmation Number"), CONTRACT("Contract"), CORPORATION_REPRESENTATIVE(
            "Corporation Representative"), CRO_CUSTOMER_RESERVATIONS_OFFICE(
            "CRO (Customer Reservations Office)"), CRUISE_LINE("Cruise Line"), CUSTOMER(
            "Customer"), DIVIDED_RESERVATION("Divided Reservation"), DISTRIBUTOR(
            "Distributor"), ERSP_ELECTRONIC_RESERVATION_SERVICE_PROVIDER(
            "ERSP (Electronic Reservation Service Provider)"), FARE_QUOTE(
            "Fare Quote"), GROUND_TRANSPORTATION_SUPPLIER(
            "Ground Transportation Supplier"), GROUP("Group"), HOTEL("Hotel"), INSURANCE_AGENCY(
            "Insurance Agency"), INSURANCE_AGENT("Insurance Agent"), INTERNET_BROKER(
            "Internet Broker"), LINKED_REFERENCE("Linked Reference"), MASTER_REFERENCE(
            "Master Reference"), MEETING_PLANNING_AGENCY(
            "Meeting Planning Agency"), MERCHANT("Merchant"), PARENT_REFERENCE(
            "Parent Reference"), PROFILE("Profile"), PROVISIONAL_RESERVATION(
            "Provisional Reservation"), PURGED_MASTER_REFERENCE(
            "Purged Master Reference"), REFERENCE("Reference"), REISSUE_REFUND_QUOTE(
            "Reissue/Refund Quote"), RESERVATION("Reservation"), TICKET(
            "Ticket"), TOUR_OPERATOR("Tour Operator"), TRAVEL_AGENCY(
            "Travel Agency"), TRAVEL_AGENT_PNR("Travel Agent PNR"), WHOLESALER(
            "Wholesaler"), OTHER_("Other_");
    private final String value;

    private EnumUniqueIDTypeBase(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumUniqueIDTypeBase convert(String value) {
        for (EnumUniqueIDTypeBase inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
