
package org.opentravel.common.v02;

import java.io.Serializable;

/** 
 * Metadata that describes a country.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://opentravel.org/common/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Identifier_Country">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attribute type="xs:string" use="optional" name="alpha2"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="fullName"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class IdentifierCountry implements Serializable
{
    private String string;
    private String alpha2;
    private String fullName;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'alpha2' attribute value. The two character alpha country code defined in ISO 3166 format.
                          
     * 
     * @return value
     */
    public String getAlpha2() {
        return alpha2;
    }

    /** 
     * Set the 'alpha2' attribute value. The two character alpha country code defined in ISO 3166 format.
                          
     * 
     * @param alpha2
     */
    public void setAlpha2(String alpha2) {
        this.alpha2 = alpha2;
    }

    /** 
     * Get the 'fullName' attribute value. The name of the country.
     * 
     * @return value
     */
    public String getFullName() {
        return fullName;
    }

    /** 
     * Set the 'fullName' attribute value. The name of the country.
     * 
     * @param fullName
     */
    public void setFullName(String fullName) {
        this.fullName = fullName;
    }
}
