
package org.opentravel.common.v02;

import java.io.Serializable;

/** 
 * Metadata that describes a unique ID and contextual information for the ID for a message
 requestor or sender.
 The ID and associated information should be known between trading partners.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://opentravel.org/common/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="InitiatorID">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attribute type="xs:string" use="optional" name="context"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="url"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class InitiatorID implements Serializable
{
    private String string;
    private String context;
    private String url;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'context' attribute value. The contextual source of the requestor ID, such as IATA, ARC, and ERSP.
                          
     * 
     * @return value
     */
    public String getContext() {
        return context;
    }

    /** 
     * Set the 'context' attribute value. The contextual source of the requestor ID, such as IATA, ARC, and ERSP.
                          
     * 
     * @param context
     */
    public void setContext(String context) {
        this.context = context;
    }

    /** 
     * Get the 'url' attribute value. A URL that identifies the location associated with the @context.
                          
     * 
     * @return value
     */
    public String getUrl() {
        return url;
    }

    /** 
     * Set the 'url' attribute value. A URL that identifies the location associated with the @context.
                          
     * 
     * @param url
     */
    public void setUrl(String url) {
        this.url = url;
    }
}
