
package org.opentravel.common.v02;

import java.io.Serializable;

/** 
 * Sine ID and other metadata about a travel agency.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://opentravel.org/common/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="InitiatorTravelAgent">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attribute type="xs:string" use="optional" name="companyName"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="dutyCode"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="pseudoCityCode"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="terminalID"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class InitiatorTravelAgent implements Serializable
{
    private String string;
    private String companyName;
    private String dutyCode;
    private String pseudoCityCode;
    private String terminalID;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'companyName' attribute value. The name of the travel agency.
     * 
     * @return value
     */
    public String getCompanyName() {
        return companyName;
    }

    /** 
     * Set the 'companyName' attribute value. The name of the travel agency.
     * 
     * @param companyName
     */
    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    /** 
     * Get the 'dutyCode' attribute value. A two to five character code (alpha, numeric or combination) code that
                              specifies a travel agents duty code used for agency authentication.
                          
     * 
     * @return value
     */
    public String getDutyCode() {
        return dutyCode;
    }

    /** 
     * Set the 'dutyCode' attribute value. A two to five character code (alpha, numeric or combination) code that
                              specifies a travel agents duty code used for agency authentication.
                          
     * 
     * @param dutyCode
     */
    public void setDutyCode(String dutyCode) {
        this.dutyCode = dutyCode;
    }

    /** 
     * Get the 'pseudoCityCode' attribute value. A three to five character code (alpha, numeric or combination) that
                              specifies a GDS code used to identify a travel agency location.
                          Note that this may be a required field when using negotiated rates to
                              associate the rates to an agency.
                          
     * 
     * @return value
     */
    public String getPseudoCityCode() {
        return pseudoCityCode;
    }

    /** 
     * Set the 'pseudoCityCode' attribute value. A three to five character code (alpha, numeric or combination) that
                              specifies a GDS code used to identify a travel agency location.
                          Note that this may be a required field when using negotiated rates to
                              associate the rates to an agency.
                          
     * 
     * @param pseudoCityCode
     */
    public void setPseudoCityCode(String pseudoCityCode) {
        this.pseudoCityCode = pseudoCityCode;
    }

    /** 
     * Get the 'terminalID' attribute value. The electronic address of the device from which information is entered.
                          
     * 
     * @return value
     */
    public String getTerminalID() {
        return terminalID;
    }

    /** 
     * Set the 'terminalID' attribute value. The electronic address of the device from which information is entered.
                          
     * 
     * @param terminalID
     */
    public void setTerminalID(String terminalID) {
        this.terminalID = terminalID;
    }
}
