
package org.opentravel.common.v02;

import java.io.Serializable;

/** 
 * Metadata that describes a message password.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://opentravel.org/common/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MessagePassword">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attribute type="xs:string" use="optional" name="domain"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class MessagePassword implements Serializable
{
    private String string;
    private String domain;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'domain' attribute value. The domain associated with the message password.
     * 
     * @return value
     */
    public String getDomain() {
        return domain;
    }

    /** 
     * Set the 'domain' attribute value. The domain associated with the message password.
     * 
     * @param domain
     */
    public void setDomain(String domain) {
        this.domain = domain;
    }
}
