
package org.opentravel.common.v02;

import java.io.Serializable;

/** 
 * Metadata that describes a target (or receiving) processing system.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://opentravel.org/common/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TargetSystem">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="ns:Enum_TargetProcessingSystem_Base">
 *       &lt;xs:attribute type="xs:string" name="extension"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="systemName"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TargetSystem implements Serializable
{
    private EnumTargetProcessingSystemBase enumTargetProcessingSystemBase;
    private String extension;
    private String systemName;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public EnumTargetProcessingSystemBase getEnumTargetProcessingSystemBase() {
        return enumTargetProcessingSystemBase;
    }

    /** 
     * Set the extension value.
     * 
     * @param enumTargetProcessingSystemBase
     */
    public void setEnumTargetProcessingSystemBase(
            EnumTargetProcessingSystemBase enumTargetProcessingSystemBase) {
        this.enumTargetProcessingSystemBase = enumTargetProcessingSystemBase;
    }

    /** 
     * Get the 'extension' attribute value.
     * 
     * @return value
     */
    public String getExtension() {
        return extension;
    }

    /** 
     * Set the 'extension' attribute value.
     * 
     * @param extension
     */
    public void setExtension(String extension) {
        this.extension = extension;
    }

    /** 
     * Get the 'systemName' attribute value. The name of the target system that may be specified if there are more than
                              one system for the specified system type.
                          
     * 
     * @return value
     */
    public String getSystemName() {
        return systemName;
    }

    /** 
     * Set the 'systemName' attribute value. The name of the target system that may be specified if there are more than
                              one system for the specified system type.
                          
     * 
     * @param systemName
     */
    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }
}
