
package org.opentravel.common.v02;

import java.io.Serializable;

/** 
 * Metadata that describes a time zone.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://opentravel.org/common/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TimeZone">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attribute type="xs:string" use="optional" name="utcOffset"/>
 *       &lt;xs:attribute type="xs:boolean" use="optional" name="daylightSavingsInd"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TimeZone implements Serializable
{
    private String string;
    private String utcOffset;
    private Boolean daylightSavingsInd;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'utcOffset' attribute value. The Coordinated Universal Time (UTC) time zone offset.A UTC offset is typically represented with a plus or minus sign, an hour
                              increment and an hour designator, such as - 5h.
                          
     * 
     * @return value
     */
    public String getUtcOffset() {
        return utcOffset;
    }

    /** 
     * Set the 'utcOffset' attribute value. The Coordinated Universal Time (UTC) time zone offset.A UTC offset is typically represented with a plus or minus sign, an hour
                              increment and an hour designator, such as - 5h.
                          
     * 
     * @param utcOffset
     */
    public void setUtcOffset(String utcOffset) {
        this.utcOffset = utcOffset;
    }

    /** 
     * Get the 'daylightSavingsInd' attribute value. If true, daylight (or summer) savings time is used in the time zone.
                          
     * 
     * @return value
     */
    public Boolean getDaylightSavingsInd() {
        return daylightSavingsInd;
    }

    /** 
     * Set the 'daylightSavingsInd' attribute value. If true, daylight (or summer) savings time is used in the time zone.
                          
     * 
     * @param daylightSavingsInd
     */
    public void setDaylightSavingsInd(Boolean daylightSavingsInd) {
        this.daylightSavingsInd = daylightSavingsInd;
    }
}
