
package org.opentravel.common.v02;

import java.io.Serializable;

/** 
 * Metadata that describes a message transaction.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://opentravel.org/common/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Transaction">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attribute type="xs:string" use="optional" name="correlationID"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="sequenceNumber"/>
 *       &lt;xs:attribute type="ns:Enum_TransactionStatus" use="optional" name="status"/>
 *       &lt;xs:attribute type="xs:boolean" use="optional" name="retransmissionInd"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Transaction implements Serializable
{
    private String string;
    private String correlationID;
    private String sequenceNumber;
    private EnumTransactionStatus status;
    private Boolean retransmissionInd;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'correlationID' attribute value. An ID for end-to-end correlation of log messages with the corresponding Web
                              service message throughout the processing of the Web service message.
                          
     * 
     * @return value
     */
    public String getCorrelationID() {
        return correlationID;
    }

    /** 
     * Set the 'correlationID' attribute value. An ID for end-to-end correlation of log messages with the corresponding Web
                              service message throughout the processing of the Web service message.
                          
     * 
     * @param correlationID
     */
    public void setCorrelationID(String correlationID) {
        this.correlationID = correlationID;
    }

    /** 
     * Get the 'sequenceNumber' attribute value. The sequence number of the transaction assigned by the sending system for
                              ordered message processing or message resynchronization.
                          Message resynchronization typically is required if a system has been
                              off-line and needs to retrieve messages that were missed.
                          
     * 
     * @return value
     */
    public String getSequenceNumber() {
        return sequenceNumber;
    }

    /** 
     * Set the 'sequenceNumber' attribute value. The sequence number of the transaction assigned by the sending system for
                              ordered message processing or message resynchronization.
                          Message resynchronization typically is required if a system has been
                              off-line and needs to retrieve messages that were missed.
                          
     * 
     * @param sequenceNumber
     */
    public void setSequenceNumber(String sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    /** 
     * Get the 'status' attribute value. Where this message falls within a sequence of messages.
     * 
     * @return value
     */
    public EnumTransactionStatus getStatus() {
        return status;
    }

    /** 
     * Set the 'status' attribute value. Where this message falls within a sequence of messages.
     * 
     * @param status
     */
    public void setStatus(EnumTransactionStatus status) {
        this.status = status;
    }

    /** 
     * Get the 'retransmissionInd' attribute value. If true, the message is being re-sent after a failure.It is recommended that this attribute is used (i.e., set to TRUE) only when
                              a message is retransmitted.
                          
     * 
     * @return value
     */
    public Boolean getRetransmissionInd() {
        return retransmissionInd;
    }

    /** 
     * Set the 'retransmissionInd' attribute value. If true, the message is being re-sent after a failure.It is recommended that this attribute is used (i.e., set to TRUE) only when
                              a message is retransmitted.
                          
     * 
     * @param retransmissionInd
     */
    public void setRetransmissionInd(Boolean retransmissionInd) {
        this.retransmissionInd = retransmissionInd;
    }
}
