
package org.opentravel.common.v02;

import java.io.Serializable;

/** 
 * Detail transaction initiator information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://opentravel.org/common/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TransactionInitiator_Detail">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:TransactionInitiator">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns:InitiatorTravelAgent" name="Agent" minOccurs="0"/>
 *         &lt;xs:element type="ns:InitiatorAirline" name="Airline" minOccurs="0"/>
 *         &lt;xs:element type="ns:InitiatorBookingChannel" name="BookingChannel" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="Company" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="RelativeLocation" minOccurs="0"/>
 *         &lt;xs:element type="ns:TimeZone" name="TimeZone" minOccurs="0"/>
 *         &lt;xs:element type="ns:Enum_TravelSector" name="TravelSector" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TransactionInitiatorDetail1 extends TransactionInitiator1
    implements Serializable
{
    private InitiatorTravelAgent agent;
    private InitiatorAirline airline;
    private InitiatorBookingChannel bookingChannel;
    private String company;
    private String relativeLocation;
    private TimeZone timeZone;
    private EnumTravelSector travelSector;

    /** 
     * Get the 'Agent' element value. The travel agent sine number and other identification and authentication
                                  information.
                              
     * 
     * @return value
     */
    public InitiatorTravelAgent getAgent() {
        return agent;
    }

    /** 
     * Set the 'Agent' element value. The travel agent sine number and other identification and authentication
                                  information.
                              
     * 
     * @param agent
     */
    public void setAgent(InitiatorTravelAgent agent) {
        this.agent = agent;
    }

    /** 
     * Get the 'Airline' element value. The two character airline IATA vendor ID and other identification and
                                  authentication information.
                              
     * 
     * @return value
     */
    public InitiatorAirline getAirline() {
        return airline;
    }

    /** 
     * Set the 'Airline' element value. The two character airline IATA vendor ID and other identification and
                                  authentication information.
                              
     * 
     * @param airline
     */
    public void setAirline(InitiatorAirline airline) {
        this.airline = airline;
    }

    /** 
     * Get the 'BookingChannel' element value. The type of the booking channel and other identification and
                                  authentication information for the requestor or sender.
                              
     * 
     * @return value
     */
    public InitiatorBookingChannel getBookingChannel() {
        return bookingChannel;
    }

    /** 
     * Set the 'BookingChannel' element value. The type of the booking channel and other identification and
                                  authentication information for the requestor or sender.
                              
     * 
     * @param bookingChannel
     */
    public void setBookingChannel(InitiatorBookingChannel bookingChannel) {
        this.bookingChannel = bookingChannel;
    }

    /** 
     * Get the 'Company' element value. Company information for the requestor or sender.
     * 
     * @return value
     */
    public String getCompany() {
        return company;
    }

    /** 
     * Set the 'Company' element value. Company information for the requestor or sender.
     * 
     * @param company
     */
    public void setCompany(String company) {
        this.company = company;
    }

    /** 
     * Get the 'RelativeLocation' element value. The geographical location of the requestor.
     * 
     * @return value
     */
    public String getRelativeLocation() {
        return relativeLocation;
    }

    /** 
     * Set the 'RelativeLocation' element value. The geographical location of the requestor.
     * 
     * @param relativeLocation
     */
    public void setRelativeLocation(String relativeLocation) {
        this.relativeLocation = relativeLocation;
    }

    /** 
     * Get the 'TimeZone' element value. A time zone abbreviation with other related metadata for the requestor
                                  or sender.
                              
     * 
     * @return value
     */
    public TimeZone getTimeZone() {
        return timeZone;
    }

    /** 
     * Set the 'TimeZone' element value. A time zone abbreviation with other related metadata for the requestor
                                  or sender.
                              
     * 
     * @param timeZone
     */
    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    /** 
     * Get the 'TravelSector' element value. The travel sector associated with the requestor or sender.
                              
     * 
     * @return value
     */
    public EnumTravelSector getTravelSector() {
        return travelSector;
    }

    /** 
     * Set the 'TravelSector' element value. The travel sector associated with the requestor or sender.
                              
     * 
     * @param travelSector
     */
    public void setTravelSector(EnumTravelSector travelSector) {
        this.travelSector = travelSector;
    }
}
