
package org.opentravel.ota;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2002/11" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SessionCreateRS">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="Success" minOccurs="0">
 *         &lt;xs:complexType/>
 *       &lt;/xs:element>
 *       &lt;xs:element name="Warnings" minOccurs="0">
 *         &lt;!-- Reference to inner class Warnings -->
 *       &lt;/xs:element>
 *       &lt;xs:element type="xs:string" name="ConversationId" minOccurs="0"/>
 *       &lt;xs:element name="Errors" minOccurs="0">
 *         &lt;!-- Reference to inner class Errors -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:string" use="optional" name="EchoToken"/>
 *     &lt;xs:attribute type="xs:string" use="optional" name="TimeStamp"/>
 *     &lt;xs:attribute use="optional" default="Production" name="Target">
 *       &lt;xs:simpleType>
 *         &lt;!-- Reference to inner class Target -->
 *       &lt;/xs:simpleType>
 *     &lt;/xs:attribute>
 *     &lt;xs:attribute type="xs:string" use="optional" name="version"/>
 *     &lt;xs:attribute type="xs:integer" use="optional" name="SequenceNmbr"/>
 *     &lt;xs:attribute type="xs:string" use="optional" name="PrimaryLangID"/>
 *     &lt;xs:attribute type="xs:string" use="optional" name="AltLangID"/>
 *     &lt;xs:attribute type="xs:string" use="optional" name="status"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class SessionCreateRS implements Serializable
{
    private boolean success;
    private Warnings warnings;
    private String conversationId;
    private Errors errors;
    private String echoToken;
    private String timeStamp;
    private Target target;
    private String version;
    private BigInteger sequenceNmbr;
    private String primaryLangID;
    private String altLangID;
    private String status;

    /** 
     * Check if the 'Success' element is present.
     * 
     * @return <code>true</code> if present, <code>false</code> if not
     */
    public boolean ifSuccessPresent() {
        return success;
    }

    /** 
     * Set flag for 'Success' element present.
     * 
     * @param success
     */
    public void flagSuccessPresent(boolean success) {
        this.success = success;
    }

    /** 
     * Get the 'Warnings' element value.
     * 
     * @return value
     */
    public Warnings getWarnings() {
        return warnings;
    }

    /** 
     * Set the 'Warnings' element value.
     * 
     * @param warnings
     */
    public void setWarnings(Warnings warnings) {
        this.warnings = warnings;
    }

    /** 
     * Get the 'ConversationId' element value.
     * 
     * @return value
     */
    public String getConversationId() {
        return conversationId;
    }

    /** 
     * Set the 'ConversationId' element value.
     * 
     * @param conversationId
     */
    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    /** 
     * Get the 'Errors' element value.
     * 
     * @return value
     */
    public Errors getErrors() {
        return errors;
    }

    /** 
     * Set the 'Errors' element value.
     * 
     * @param errors
     */
    public void setErrors(Errors errors) {
        this.errors = errors;
    }

    /** 
     * Get the 'EchoToken' attribute value. A sequence number for additional message identification, assigned by the requesting host system. When a request 										message includes an echo token the corresponding response message MUST include an echo token with an identical value.											
     * 
     * @return value
     */
    public String getEchoToken() {
        return echoToken;
    }

    /** 
     * Set the 'EchoToken' attribute value. A sequence number for additional message identification, assigned by the requesting host system. When a request 										message includes an echo token the corresponding response message MUST include an echo token with an identical value.											
     * 
     * @param echoToken
     */
    public void setEchoToken(String echoToken) {
        this.echoToken = echoToken;
    }

    /** 
     * Get the 'TimeStamp' attribute value. Indicates the creation date and time of the message in UTC using the following format specified by ISO 8601; YYYY-	MM-					DDThh:mm:ssZ with time values using the 24 hour clock (e.g. 20 November 2003, 1:59:38 pm UTC becomes 2003-11-	20T13:59:38Z).						
     * 
     * @return value
     */
    public String getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'TimeStamp' attribute value. Indicates the creation date and time of the message in UTC using the following format specified by ISO 8601; YYYY-	MM-					DDThh:mm:ssZ with time values using the 24 hour clock (e.g. 20 November 2003, 1:59:38 pm UTC becomes 2003-11-	20T13:59:38Z).						
     * 
     * @param timeStamp
     */
    public void setTimeStamp(String timeStamp) {
        this.timeStamp = timeStamp;
    }

    /** 
     * Get the 'Target' attribute value. Used to indicate whether the request is for the Test or Production system.
     * 
     * @return value
     */
    public Target getTarget() {
        return target;
    }

    /** 
     * Set the 'Target' attribute value. Used to indicate whether the request is for the Test or Production system.
     * 
     * @param target
     */
    public void setTarget(Target target) {
        this.target = target;
    }

    /** 
     * Get the 'version' attribute value. For all OTA versioned messages, the version of the message is indicated by a decimal value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'version' attribute value. For all OTA versioned messages, the version of the message is indicated by a decimal value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }

    /** 
     * Get the 'SequenceNmbr' attribute value. Used to identify the sequence number of the transaction as assigned by the sending system; allows for an application 	to 					process messages in a certain order or to request a resynchronization of messages in the event that a system has been off-line and 	needs to 				retrieve messages that were missed. 
     * 
     * @return value
     */
    public BigInteger getSequenceNmbr() {
        return sequenceNmbr;
    }

    /** 
     * Set the 'SequenceNmbr' attribute value. Used to identify the sequence number of the transaction as assigned by the sending system; allows for an application 	to 					process messages in a certain order or to request a resynchronization of messages in the event that a system has been off-line and 	needs to 				retrieve messages that were missed. 
     * 
     * @param sequenceNmbr
     */
    public void setSequenceNmbr(BigInteger sequenceNmbr) {
        this.sequenceNmbr = sequenceNmbr;
    }

    /** 
     * Get the 'PrimaryLangID' attribute value. Identifes the primary language preference for the form of travel represented in a collection.
    				 The human language is identified by ISO 639 codes.
     * 
     * @return value
     */
    public String getPrimaryLangID() {
        return primaryLangID;
    }

    /** 
     * Set the 'PrimaryLangID' attribute value. Identifes the primary language preference for the form of travel represented in a collection.
    				 The human language is identified by ISO 639 codes.
     * 
     * @param primaryLangID
     */
    public void setPrimaryLangID(String primaryLangID) {
        this.primaryLangID = primaryLangID;
    }

    /** 
     * Get the 'AltLangID' attribute value. Identifes the primary language preference for the form of travel represented in a collection.
    				 The human language is identified by ISO 639 codes.
     * 
     * @return value
     */
    public String getAltLangID() {
        return altLangID;
    }

    /** 
     * Set the 'AltLangID' attribute value. Identifes the primary language preference for the form of travel represented in a collection.
    				 The human language is identified by ISO 639 codes.
     * 
     * @param altLangID
     */
    public void setAltLangID(String altLangID) {
        this.altLangID = altLangID;
    }

    /** 
     * Get the 'status' attribute value.
     * 
     * @return value
     */
    public String getStatus() {
        return status;
    }

    /** 
     * Set the 'status' attribute value.
     * 
     * @param status
     */
    public void setStatus(String status) {
        this.status = status;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2002/11" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Warnings" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Warning">
     *         &lt;xs:complexType>
     *           &lt;xs:attribute type="xs:string" use="optional" name="Language"/>
     *           &lt;xs:attribute type="xs:string" use="optional" name="ShortText"/>
     *           &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
     *           &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
     *           &lt;xs:attribute type="xs:string" use="optional" name="DocURL"/>
     *           &lt;xs:attribute type="xs:string" use="optional" name="Status"/>
     *           &lt;xs:attribute type="xs:string" use="optional" name="Tag"/>
     *           &lt;xs:attribute type="xs:string" use="optional" name="RecordId"/>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Warnings implements Serializable
    {
        private String warningLanguage;
        private String warningShortText;
        private String warningType;
        private String warningCode;
        private String warningDocURL;
        private String warningStatus;
        private String warningTag;
        private String warningRecordId;

        /** 
         * Get the 'Language' attribute value.
         * 
         * @return value
         */
        public String getWarningLanguage() {
            return warningLanguage;
        }

        /** 
         * Set the 'Language' attribute value.
         * 
         * @param warningLanguage
         */
        public void setWarningLanguage(String warningLanguage) {
            this.warningLanguage = warningLanguage;
        }

        /** 
         * Get the 'ShortText' attribute value.
         * 
         * @return value
         */
        public String getWarningShortText() {
            return warningShortText;
        }

        /** 
         * Set the 'ShortText' attribute value.
         * 
         * @param warningShortText
         */
        public void setWarningShortText(String warningShortText) {
            this.warningShortText = warningShortText;
        }

        /** 
         * Get the 'Type' attribute value.
         * 
         * @return value
         */
        public String getWarningType() {
            return warningType;
        }

        /** 
         * Set the 'Type' attribute value.
         * 
         * @param warningType
         */
        public void setWarningType(String warningType) {
            this.warningType = warningType;
        }

        /** 
         * Get the 'Code' attribute value. If present, this refers to a table of coded values exchanged between applications to identify errors or warnings.
         * 
         * @return value
         */
        public String getWarningCode() {
            return warningCode;
        }

        /** 
         * Set the 'Code' attribute value. If present, this refers to a table of coded values exchanged between applications to identify errors or warnings.
         * 
         * @param warningCode
         */
        public void setWarningCode(String warningCode) {
            this.warningCode = warningCode;
        }

        /** 
         * Get the 'DocURL' attribute value. If present, this URL refers to an online description of the error that occurred.
         * 
         * @return value
         */
        public String getWarningDocURL() {
            return warningDocURL;
        }

        /** 
         * Set the 'DocURL' attribute value. If present, this URL refers to an online description of the error that occurred.
         * 
         * @param warningDocURL
         */
        public void setWarningDocURL(String warningDocURL) {
            this.warningDocURL = warningDocURL;
        }

        /** 
         * Get the 'Status' attribute value. If present, recommended values are those enumerated in the OTA_ErrorRS, (NotProcessed | Incomplete | Complete | Unknown) however, the data type is designated as string data, recognizing that trading partners may identify additional status conditions not included in the enumeration.
         * 
         * @return value
         */
        public String getWarningStatus() {
            return warningStatus;
        }

        /** 
         * Set the 'Status' attribute value. If present, recommended values are those enumerated in the OTA_ErrorRS, (NotProcessed | Incomplete | Complete | Unknown) however, the data type is designated as string data, recognizing that trading partners may identify additional status conditions not included in the enumeration.
         * 
         * @param warningStatus
         */
        public void setWarningStatus(String warningStatus) {
            this.warningStatus = warningStatus;
        }

        /** 
         * Get the 'Tag' attribute value. If present, this attribute may identify an unknown or misspelled tag that caused an error in processing. It is recommended that the Tag attribute use XPath notation to identify the location of a tag in the event that more than one tag of the same name is present in the document. Alternatively, the tag name alone can be used to identify missing data [Type=ReqFieldMissing].
         * 
         * @return value
         */
        public String getWarningTag() {
            return warningTag;
        }

        /** 
         * Set the 'Tag' attribute value. If present, this attribute may identify an unknown or misspelled tag that caused an error in processing. It is recommended that the Tag attribute use XPath notation to identify the location of a tag in the event that more than one tag of the same name is present in the document. Alternatively, the tag name alone can be used to identify missing data [Type=ReqFieldMissing].
         * 
         * @param warningTag
         */
        public void setWarningTag(String warningTag) {
            this.warningTag = warningTag;
        }

        /** 
         * Get the 'RecordId' attribute value. If present, this attribute allows for batch processing and the identification of the record that failed amongst a group of records.
         * 
         * @return value
         */
        public String getWarningRecordId() {
            return warningRecordId;
        }

        /** 
         * Set the 'RecordId' attribute value. If present, this attribute allows for batch processing and the identification of the record that failed amongst a group of records.
         * 
         * @param warningRecordId
         */
        public void setWarningRecordId(String warningRecordId) {
            this.warningRecordId = warningRecordId;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2002/11" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Errors" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Error">
     *         &lt;xs:complexType>
     *           &lt;xs:sequence>
     *             &lt;xs:element name="ErrorInfo">
     *               &lt;xs:complexType>
     *                 &lt;xs:sequence>
     *                   &lt;xs:element type="xs:string" name="Message"/>
     *                 &lt;/xs:sequence>
     *               &lt;/xs:complexType>
     *             &lt;/xs:element>
     *           &lt;/xs:sequence>
     *           &lt;xs:attribute type="xs:string" use="required" name="ErrorCode"/>
     *           &lt;xs:attribute type="xs:string" use="required" name="Severity"/>
     *           &lt;xs:attribute type="xs:string" use="required" name="ErrorMessage"/>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Errors implements Serializable
    {
        private String errorErrorInfo;
        private String errorErrorCode;
        private String errorSeverity;
        private String errorErrorMessage;

        /** 
         * Get the 'Message' element value.
         * 
         * @return value
         */
        public String getErrorErrorInfo() {
            return errorErrorInfo;
        }

        /** 
         * Set the 'Message' element value.
         * 
         * @param errorErrorInfo
         */
        public void setErrorErrorInfo(String errorErrorInfo) {
            this.errorErrorInfo = errorErrorInfo;
        }

        /** 
         * Get the 'ErrorCode' attribute value.
         * 
         * @return value
         */
        public String getErrorErrorCode() {
            return errorErrorCode;
        }

        /** 
         * Set the 'ErrorCode' attribute value.
         * 
         * @param errorErrorCode
         */
        public void setErrorErrorCode(String errorErrorCode) {
            this.errorErrorCode = errorErrorCode;
        }

        /** 
         * Get the 'Severity' attribute value.
         * 
         * @return value
         */
        public String getErrorSeverity() {
            return errorSeverity;
        }

        /** 
         * Set the 'Severity' attribute value.
         * 
         * @param errorSeverity
         */
        public void setErrorSeverity(String errorSeverity) {
            this.errorSeverity = errorSeverity;
        }

        /** 
         * Get the 'ErrorMessage' attribute value.
         * 
         * @return value
         */
        public String getErrorErrorMessage() {
            return errorErrorMessage;
        }

        /** 
         * Set the 'ErrorMessage' attribute value.
         * 
         * @param errorErrorMessage
         */
        public void setErrorErrorMessage(String errorErrorMessage) {
            this.errorErrorMessage = errorErrorMessage;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="Test"/>
     *     &lt;xs:enumeration value="Production"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum Target implements Serializable {
        TEST("Test"), PRODUCTION("Production");
        private final String value;

        private Target(String value) {
            this.value = value;
        }

        public String xmlValue() {
            return value;
        }

        public static Target convert(String value) {
            for (Target inst : values()) {
                if (inst.xmlValue().equals(value)) {
                    return inst;
                }
            }
            return null;
        }
    }
}
