
package org.w3.xml.namespace;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:attributeGroup xmlns:xml="http://www.w3.org/XML/1998/namespace" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="specialAttrs">
 *   &lt;xs:attribute ref="xml:base">
 *     &lt;!-- Reference to inner class Base -->
 *   &lt;/xs:attribute>
 *   &lt;xs:attribute ref="xml:lang">
 *     &lt;!-- Reference to inner class Lang -->
 *   &lt;/xs:attribute>
 *   &lt;xs:attribute ref="xml:space">
 *     &lt;!-- Reference to inner class Space -->
 *   &lt;/xs:attribute>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class SpecialAttrs implements Serializable
{
    private Base base;
    private Lang lang;
    private Space space;

    /** 
     * Get the 'base' attribute value.
     * 
     * @return value
     */
    public Base getBase() {
        return base;
    }

    /** 
     * Set the 'base' attribute value.
     * 
     * @param base
     */
    public void setBase(Base base) {
        this.base = base;
    }

    /** 
     * Get the 'lang' attribute value.
     * 
     * @return value
     */
    public Lang getLang() {
        return lang;
    }

    /** 
     * Set the 'lang' attribute value.
     * 
     * @param lang
     */
    public void setLang(Lang lang) {
        this.lang = lang;
    }

    /** 
     * Get the 'space' attribute value.
     * 
     * @return value
     */
    public Space getSpace() {
        return space;
    }

    /** 
     * Set the 'space' attribute value.
     * 
     * @param space
     */
    public void setSpace(Space space) {
        this.space = space;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:attribute xmlns:ns="http://www.w3.org/XML/1998/namespace" xmlns:xs="http://www.w3.org/2001/XMLSchema" ref="xml:base"/>
     * 
     * &lt;xs:attribute xmlns:ns="http://www.w3.org/XML/1998/namespace" xmlns:xs="http://www.w3.org/2001/XMLSchema" type="xs:string" name="base"/>
     * </pre>
     */
    public static class Base implements Serializable
    {
        private String base;

        /** 
         * Get the 'base' attribute value. See http://www.w3.org/TR/xmlbase/ for
                         information about this attribute.
         * 
         * @return value
         */
        public String getBase() {
            return base;
        }

        /** 
         * Set the 'base' attribute value. See http://www.w3.org/TR/xmlbase/ for
                         information about this attribute.
         * 
         * @param base
         */
        public void setBase(String base) {
            this.base = base;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:attribute xmlns:ns="http://www.w3.org/XML/1998/namespace" xmlns:xs="http://www.w3.org/2001/XMLSchema" ref="xml:lang"/>
     * 
     * &lt;xs:attribute xmlns:ns="http://www.w3.org/XML/1998/namespace" xmlns:xs="http://www.w3.org/2001/XMLSchema" type="xs:string" name="lang"/>
     * </pre>
     */
    public static class Lang implements Serializable
    {
        private String lang;

        /** 
         * Get the 'lang' attribute value. In due course, we should install the relevant ISO 2- and 3-letter
             codes as the enumerated possible values . . .
         * 
         * @return value
         */
        public String getLang() {
            return lang;
        }

        /** 
         * Set the 'lang' attribute value. In due course, we should install the relevant ISO 2- and 3-letter
             codes as the enumerated possible values . . .
         * 
         * @param lang
         */
        public void setLang(String lang) {
            this.lang = lang;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:attribute xmlns:ns="http://www.w3.org/XML/1998/namespace" xmlns:xs="http://www.w3.org/2001/XMLSchema" ref="xml:space"/>
     * 
     * &lt;xs:attribute xmlns:ns="http://www.w3.org/XML/1998/namespace" xmlns:xs="http://www.w3.org/2001/XMLSchema" default="preserve" name="space">
     *   &lt;xs:simpleType>
     *     &lt;!-- Reference to inner class SpaceInner -->
     *   &lt;/xs:simpleType>
     * &lt;/xs:attribute>
     * </pre>
     */
    public static class Space implements Serializable
    {
        private SpaceInner space;

        /** 
         * Get the 'space' attribute value.
         * 
         * @return value
         */
        public SpaceInner getSpace() {
            return space;
        }

        /** 
         * Set the 'space' attribute value.
         * 
         * @param space
         */
        public void setSpace(SpaceInner space) {
            this.space = space;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
         *   &lt;xs:restriction base="xs:string">
         *     &lt;xs:enumeration value="default"/>
         *     &lt;xs:enumeration value="preserve"/>
         *   &lt;/xs:restriction>
         * &lt;/xs:simpleType>
         * </pre>
         */
        public static enum SpaceInner implements Serializable {
            DEFAULT("default"), PRESERVE("preserve");
            private final String value;

            private SpaceInner(String value) {
                this.value = value;
            }

            public String xmlValue() {
                return value;
            }

            public static SpaceInner convert(String value) {
                for (SpaceInner inst : values()) {
                    if (inst.xmlValue().equals(value)) {
                        return inst;
                    }
                }
                return null;
            }
        }
    }
}
