
package org.w3.xmldsig;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.w3.org/2000/09/xmldsig#" xmlns:xs="http://www.w3.org/2001/XMLSchema" mixed="true" name="SignaturePropertyType">
 *   &lt;xs:choice>
 *     &lt;xs:any maxOccurs="unbounded" processContents="lax" namespace="##other"/>
 *   &lt;/xs:choice>
 *   &lt;xs:attribute type="xs:string" use="required" name="Target"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Id"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SignaturePropertyType implements Serializable
{
    private List<Element> anyList = new ArrayList<Element>();
    private String target;
    private String id;

    /** 
     * Get the list of choice items.
     * 
     * @return list
     */
    public List<Element> getAnyList() {
        return anyList;
    }

    /** 
     * Set the list of choice items.
     * 
     * @param list
     */
    public void setAnyList(List<Element> list) {
        anyList = list;
    }

    /** 
     * Get the 'Target' attribute value.
     * 
     * @return value
     */
    public String getTarget() {
        return target;
    }

    /** 
     * Set the 'Target' attribute value.
     * 
     * @param target
     */
    public void setTarget(String target) {
        this.target = target;
    }

    /** 
     * Get the 'Id' attribute value.
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'Id' attribute value.
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }
}
