
package org.xmlsoap.schemas.soap.envelope;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://schemas.xmlsoap.org/soap/envelope/" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Envelope">
 *   &lt;xs:sequence>
 *     &lt;xs:element ref="ns:Header" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element ref="ns:Body"/>
 *     &lt;xs:any minOccurs="0" maxOccurs="unbounded" processContents="lax" namespace="##other"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:anyAttribute processContents="lax" namespace="##other"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Envelope implements Serializable
{
    private List<Header> headerList = new ArrayList<Header>();
    private Body body;
    private List<Element> anyList = new ArrayList<Element>();

    /** 
     * Get the list of 'Header' element items.
     * 
     * @return list
     */
    public List<Header> getHeaderList() {
        return headerList;
    }

    /** 
     * Set the list of 'Header' element items.
     * 
     * @param list
     */
    public void setHeaderList(List<Header> list) {
        headerList = list;
    }

    /** 
     * Get the 'Body' element value.
     * 
     * @return value
     */
    public Body getBody() {
        return body;
    }

    /** 
     * Set the 'Body' element value.
     * 
     * @param body
     */
    public void setBody(Body body) {
        this.body = body;
    }

    /** 
     * Get the list of any items.
     * 
     * @return list
     */
    public List<Element> getAnyList() {
        return anyList;
    }

    /** 
     * Set the list of any items.
     * 
     * @param list
     */
    public void setAnyList(List<Element> list) {
        anyList = list;
    }
}
