/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000;

import com.gridnine.bof.midoffice.ibus.BookingFileOperationParameters;
import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaHelper;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.Aircraft;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.model.OrderAnswer;
import com.gridnine.xtrip.server.gds.sirena2000.model.Pnr;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public class GetAirplaneProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        OrderAnswer answer = (OrderAnswer)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_ANSWER);
        List products = (List)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BASE_PRODUCTS);
        Map<String, Pnr.Segments.Segment> airplanes = answer.getPnr().getSegments().getSegments().stream().collect(Collectors.toMap(Pnr.Segments.Segment::getFlight, segment -> segment));
        AtomicBoolean segmentsChanged = new AtomicBoolean();
        for (Product product : products) {
            product.getSegmentTariffs().forEach(segmentTariff -> segmentTariff.getSegments().stream().filter(segment -> segment.getBoard() == null).forEach(segment -> {
                Pnr.Segments.Segment seg = (Pnr.Segments.Segment)airplanes.get(segment.getFlightNo());
                if (seg == null) {
                    ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)String.format("\u0421\u0435\u0433\u043c\u0435\u043d\u0442 \u0441 \u043d\u043e\u043c\u0435\u0440\u043e\u043c %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u0431\u0438\u043b\u0435\u0442\u0435", segment.getFlightNo()), (Object[])new Object[0]));
                } else {
                    String airplaneNumber = ((Pnr.Segments.Segment)airplanes.get(segment.getFlightNo())).getAirplane();
                    if (airplaneNumber == null) {
                        ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)String.format("\u0421\u0430\u043c\u043e\u043b\u0435\u0442 \u0441 \u043d\u043e\u043c\u0435\u0440\u043e\u043c %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0435", ((Pnr.Segments.Segment)airplanes.get(segment.getFlightNo())).getAirplane()), (Object[])new Object[0]));
                    } else {
                        DictionaryReference airplane = SirenaHelper.resolveNativeCode(Aircraft.class, (String)((Pnr.Segments.Segment)airplanes.get(segment.getFlightNo())).getAirplane());
                        if (airplane == null) {
                            ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)String.format("\u0421\u0430\u043c\u043e\u043b\u0435\u0442 \u0441 \u043d\u043e\u043c\u0435\u0440\u043e\u043c %s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435", ((Pnr.Segments.Segment)airplanes.get(segment.getFlightNo())).getAirplane()), (Object[])new Object[0]));
                        } else {
                            segment.setBoard(airplane);
                            segmentsChanged.set(true);
                        }
                    }
                }
            }));
        }
        if (!segmentsChanged.get()) {
            BookingFileOperationParameters parameters = (BookingFileOperationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_OPERATION_PARAMETERS);
            parameters.setSaveBookingFile(false);
        }
    }
}

