/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000;

import com.gridnine.bof.midoffice.helper.MidofficeHelper;
import com.gridnine.xtrip.common.gds.sirena2000.KeyInfo;
import com.gridnine.xtrip.common.util.DateInterval;
import com.gridnine.xtrip.common.util.Settings;
import com.gridnine.xtrip.server.SecurityHelper;
import com.gridnine.xtrip.server.gds.sirena2000.model.KeyInfoAnswer;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HandlerKeyInfo {
    private static final Logger log = LoggerFactory.getLogger(HandlerKeyInfo.class);
    private static Configuration config;

    public static void processResponse(KeyInfoAnswer answer, KeyInfo keyInfo, String clientId) throws IOException {
        if (answer.getKeyManager().getKeys() != null) {
            for (KeyInfoAnswer.KeyManager.Key key : answer.getKeyManager().getKeys()) {
                String state = key.getState();
                if ("current".equalsIgnoreCase(state)) {
                    keyInfo.setCurrentClientKeyDigest(key.getValue());
                    continue;
                }
                if ("future".equalsIgnoreCase(state)) {
                    keyInfo.setFutureClientKeyDigest(key.getValue());
                    continue;
                }
                log.warn("unknown key state " + state);
            }
        }
        keyInfo.setUnconfirmedClientKeyDigest(answer.getKeyManager().getUnconfirmed());
        String expireStr = answer.getKeyManager().getExpiration();
        if (expireStr != null) {
            try {
                keyInfo.setCurrentClientKeyExpired(new SimpleDateFormat("HH:mm dd.MM.yyyy").parse(expireStr));
            }
            catch (ParseException pe) {
                log.error("failed parsing key expire date", (Throwable)pe);
            }
        }
        keyInfo.setServerPublicKey(answer.getKeyManager().getServerPublicKey());
        HandlerKeyInfo.doNotification(keyInfo, clientId);
    }

    private static synchronized void doNotification(KeyInfo keyInfo, String clientID) {
        DateInterval di;
        if (config == null) {
            config = new Configuration();
            config.load();
        }
        if (config.getLastPublicKeyReport() != null && new DateInterval(config.getLastPublicKeyReport(), new Date()).getDuration(11) < 24) {
            log.debug("client key notification skipped, last notification was done " + config.getLastPublicKeyReport());
            return;
        }
        StringBuilder report = new StringBuilder();
        String nl = "\r\n";
        if (keyInfo.getCurrentClientKeyDigest() == null) {
            report.append("No client public key registered on the server, secure communications will fail.").append(nl).append(nl);
        } else if (keyInfo.getFutureClientKeyDigest() == null && keyInfo.getCurrentClientKeyExpired() != null && (di = new DateInterval(new Date(), keyInfo.getCurrentClientKeyExpired())).getDuration(5) <= 10) {
            report.append("Client public key will expire ").append(new SimpleDateFormat("dd.MM.yyyy HH:mm").format(di.getEndDate())).append(" No future client public keys registered yet.").append(nl);
        }
        if (keyInfo.getUnconfirmedClientKeyDigest() != null) {
            report.append("There is unconfirmed client public key uploaded to server. SHA-1 digest is:").append(nl).append(SecurityHelper.buildMessage((String)"DIGEST", (byte[])keyInfo.getUnconfirmedClientKeyDigest())).append(nl);
        }
        if (report.length() != 0) {
            String header = String.format("This is automatically generated message to remind you about client public key registrations on Sirena GRS to make secure communications work properly. Your client ID is %s", clientID);
            report.insert(0, header + nl + nl);
            log.warn("client key check report:" + report);
            report.append(MidofficeHelper.getStandardPlainTextFooter((String)nl));
            MidofficeHelper.sendSystemEmail((String)"Sirena-2000 Public Key Notification", (String)report.toString());
        }
        config.setLastPublicKeyReport(new Date());
        config.save();
    }

    private HandlerKeyInfo() {
    }

    private static class Configuration
    extends Settings {
        private Date lastPublicKeyReport;

        Configuration() {
            super(Configuration.class);
        }

        Date getLastPublicKeyReport() {
            return this.lastPublicKeyReport;
        }

        void setLastPublicKeyReport(Date value) {
            this.lastPublicKeyReport = value;
        }

        protected void read(Properties props) throws Exception {
            String value = props.getProperty("lastPublicKeyReport", null);
            this.lastPublicKeyReport = value != null ? this.getDateFormat().parse(value) : null;
        }

        protected void write(Properties props) throws Exception {
            if (this.lastPublicKeyReport != null) {
                props.setProperty("lastPublicKeyReport", this.getDateFormat().format(this.lastPublicKeyReport));
            } else {
                props.remove("lastPublicKeyReport");
            }
        }

        private DateFormat getDateFormat() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    }
}

