/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000;

import com.gridnine.xtrip.server.gds.sirena2000.SSLSessionManager;
import java.io.IOException;
import javax.xml.stream.XMLStreamWriter;

public final class Header {
    static final int SIZE = 100;
    private static int lastId = (int)(System.currentTimeMillis() / 1000L);
    private final SSLSessionManager ssManager;
    private int length;
    private final int timestamp;
    private final int id;
    private final short clientId;
    private byte flags;
    private byte flags2;
    private int symmetricKeyId;
    private final transient int hashCode;

    private static synchronized int getNextId() {
        return lastId++;
    }

    public static Header create(short clientId, SSLSessionManager ssManager) {
        return new Header((int)(System.currentTimeMillis() / 1000L), Header.getNextId(), clientId, ssManager);
    }

    static Header read(byte[] buf, int offset, SSLSessionManager ssManager) throws IOException {
        if (buf.length - offset < 100) {
            throw new IOException("invalid buffer size");
        }
        Header result = new Header(Header.readInt(buf, offset + 4), Header.readInt(buf, offset + 8), Header.readShort(buf, offset + 44), ssManager);
        result.length = Header.readInt(buf, offset);
        result.flags = buf[46];
        result.flags2 = buf[47];
        result.symmetricKeyId = Header.readInt(buf, offset + 48);
        return result;
    }

    static void write(byte[] buf, int offset, Header value) throws IOException {
        if (buf.length - offset < 100) {
            throw new IOException("invalid buffer size");
        }
        Header.writeInt(buf, offset, value.length);
        Header.writeInt(buf, offset + 4, value.timestamp);
        Header.writeInt(buf, offset + 8, value.id);
        Header.writeShort(buf, offset + 44, value.clientId);
        buf[offset + 46] = value.flags;
        Header.writeInt(buf, offset + 48, value.symmetricKeyId);
    }

    public static int readInt(byte[] buf, int offset) {
        return ((buf[offset + 3] & 0xFF) << 0) + ((buf[offset + 2] & 0xFF) << 8) + ((buf[offset + 1] & 0xFF) << 16) + ((buf[offset + 0] & 0xFF) << 24);
    }

    private static short readShort(byte[] buf, int offset) {
        return (short)(((buf[offset + 1] & 0xFF) << 0) + ((buf[offset + 0] & 0xFF) << 8));
    }

    public static void writeInt(byte[] buf, int offset, int value) {
        buf[offset + 0] = (byte)(value >> 24 & 0xFF);
        buf[offset + 1] = (byte)(value >> 16 & 0xFF);
        buf[offset + 2] = (byte)(value >> 8 & 0xFF);
        buf[offset + 3] = (byte)(value & 0xFF);
    }

    private static void writeShort(byte[] buf, int offset, short value) {
        buf[offset + 0] = (byte)(value >> 8 & 0xFF);
        buf[offset + 1] = (byte)(value & 0xFF);
    }

    private Header(int ts, int anId, short clId, SSLSessionManager sm) {
        this.timestamp = ts;
        this.id = anId;
        this.clientId = clId;
        this.ssManager = sm;
        this.hashCode = this.timestamp ^ this.id ^ 0x12D691;
    }

    SSLSessionManager getSessionManager() {
        return this.ssManager;
    }

    public int getLength() {
        return this.length;
    }

    void setLength(int value) {
        this.length = value;
    }

    int getTimestamp() {
        return this.timestamp;
    }

    int getId() {
        return this.id;
    }

    short getClientId() {
        return this.clientId;
    }

    public int getSymmetricKeyId() {
        return this.symmetricKeyId;
    }

    void setSymmetricKeyId(int value) {
        this.symmetricKeyId = value;
    }

    boolean isDataCompressionAllowed() {
        return (this.flags & 0x10) != 0;
    }

    public void setDataCompressionAllowed(boolean value) {
        this.flags = value ? (byte)(this.flags | 0x10) : (byte)(this.flags & 0xFFFFFFEF);
    }

    boolean isDataCompressed() {
        return (this.flags & 4) != 0;
    }

    void setDataCompressed(boolean value) {
        this.flags = value ? (byte)(this.flags | 4) : (byte)(this.flags & 0xFFFFFFFB);
    }

    boolean isSymmetricKeyEncryption() {
        return (this.flags & 8) != 0;
    }

    void setSymmetricKeyEncryption(boolean value) {
        this.flags = value ? (byte)(this.flags | 8) : (byte)(this.flags & 0xFFFFFFF7);
    }

    public boolean isPublicKeyEncryption() {
        return (this.flags & 0x40) != 0;
    }

    public void setPublicKeyEncryption(boolean value) {
        this.flags = value ? (byte)(this.flags | 0x40) : (byte)(this.flags & 0xFFFFFFBF);
    }

    boolean isNotProcessed() {
        return (this.flags2 & 1) != 0;
    }

    void setNotProcessed(boolean value) {
        this.flags2 = value ? (byte)(this.flags2 | 1) : (byte)(this.flags2 & 0xFFFFFFFE);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Header)) {
            return false;
        }
        Header other = (Header)obj;
        return this.timestamp == other.timestamp && this.id == other.id;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return String.format("{requestHeader: id=%s; timestamp=%s; length=%s; compressed=%s}", this.id, this.timestamp, this.length, this.isDataCompressed());
    }

    void toXML(XMLStreamWriter xsw) throws Exception {
        this.writeElement(xsw, "client-id", String.valueOf(this.getClientId()));
        this.writeElement(xsw, "id", String.valueOf(this.getId()));
        this.writeElement(xsw, "timestamp", String.valueOf(this.getTimestamp()));
        this.writeElement(xsw, "length", String.valueOf(this.getLength()));
        this.writeElement(xsw, "compressed", String.valueOf(this.isDataCompressed()));
        this.writeElement(xsw, "compression-allowed", String.valueOf(this.isDataCompressionAllowed()));
        this.writeElement(xsw, "symmetric-key-encryption", String.valueOf(this.isSymmetricKeyEncryption()));
        this.writeElement(xsw, "public-key-encryption", String.valueOf(this.isPublicKeyEncryption()));
        this.writeElement(xsw, "not-processed", String.valueOf(this.isNotProcessed()));
        this.writeElement(xsw, "symmetric-key-id", String.valueOf(this.getSymmetricKeyId()));
    }

    private void writeElement(XMLStreamWriter xsw, String localName, String value) throws Exception {
        xsw.writeStartElement(localName);
        xsw.writeCharacters(value);
        xsw.writeEndElement();
    }

    public Header _clone() {
        Header clone = new Header((int)(System.currentTimeMillis() / 1000L), Header.getNextId(), this.clientId, this.ssManager);
        clone.flags = this.flags;
        clone.flags2 = this.flags2;
        clone.length = this.length;
        clone.symmetricKeyId = this.symmetricKeyId;
        return clone;
    }
}

