/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.RouteSegment;
import com.gridnine.xtrip.common.gds.sirena2000.model.SirenaGdsAccount;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class LogStatsAdvice
extends BaseAdvice {
    public void after(MessageContext ctx) throws Exception {
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        this.logStats((EntityContainer<SirenaGdsAccount>)accountCtr, ctx);
    }

    private void logStats(EntityContainer<SirenaGdsAccount> accountCtr, MessageContext ctx) {
        String gdsAccountName = this.getGdsAccountName(accountCtr);
        Logger sirenaStatsLogger = Logger.getLogger((String)"sirenastats");
        if (sirenaStatsLogger == null) {
            this.log.error("Can't find sirenastats logger");
            return;
        }
        StringBuilder routeText = this.composeRouteText(ctx);
        String user = this.getUser(ctx);
        sirenaStatsLogger.debug((Object)String.format("%s;%s;%s%s", gdsAccountName, user, routeText.toString(), System.getProperty("line.separator")));
    }

    private String getUser(MessageContext ctx) {
        SalesContext salesContext = (SalesContext)ctx.getObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        if (salesContext == null) {
            return "";
        }
        EntityReference agentRef = salesContext.getAgent();
        if (agentRef == null) {
            return "";
        }
        EntityContainer agentCtr = EntityStorage.get().resolve(agentRef);
        if (agentCtr == null) {
            return "";
        }
        Person agent = (Person)agentCtr.getEntity();
        if (agent == null) {
            return "";
        }
        return agent.getLoginName();
    }

    private StringBuilder composeRouteText(MessageContext ctx) {
        List route;
        StringBuilder routeText = new StringBuilder();
        FlightSearchParameters fsp = (FlightSearchParameters)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS);
        if (fsp != null && (route = fsp.getRoute()) != null) {
            for (RouteSegment segment : route) {
                if (segment == null) continue;
                routeText.append("" + segment.getLocationBegin());
                routeText.append(",");
                routeText.append("" + segment.getLocationEnd());
                routeText.append(",");
            }
        }
        return routeText;
    }

    private String getGdsAccountName(EntityContainer<SirenaGdsAccount> accountCtr) {
        if (accountCtr == null) {
            return "";
        }
        SirenaGdsAccount account = (SirenaGdsAccount)accountCtr.getEntity();
        if (account == null) {
            return "";
        }
        GdsName name = account.getGds();
        String gdsName = "";
        if (name != null) {
            gdsName = name.name();
        }
        String sirenaAccount = StringUtils.defaultIfBlank((String)account.getAccount(), (String)"");
        return String.format("%s/%s/%s", account.getName(), gdsName, sirenaAccount);
    }
}

