/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.ibus.gdsTracing.GdsTracingItemBuilder;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.gds.sirena2000.model.SirenaGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.SirenaGate;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.codec.digest.DigestUtils;

public class LoggingAdvice
extends BaseAdvice {
    private static final byte[] XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>".getBytes();

    public void before(MessageContext ctx) throws Exception {
        GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
        boolean checkTracingSettings = Boolean.TRUE.equals(ctx.getObject((Enum)IBusGdsContextKeys.CHECK_TRACING_SETTINGS));
        if (checkTracingSettings) {
            if (gdsTracingSettings != null && gdsTracingSettings.isActive() && gdsTracingSettings.isSaveSearchTraces()) {
                ctx.putObject((Enum)IBusGdsSirenaContextKeys.SIRENA_TRANSACTIONS, new ArrayList());
            }
        } else {
            ctx.putObject((Enum)IBusGdsSirenaContextKeys.SIRENA_TRANSACTIONS, new ArrayList());
        }
    }

    public void after(MessageContext ctx) throws Exception {
        boolean doTrace;
        List transactions = (List)ctx.getObject((Enum)IBusGdsSirenaContextKeys.SIRENA_TRANSACTIONS);
        if (null == transactions) {
            return;
        }
        GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
        boolean doBuildDocument = Boolean.TRUE.equals(ctx.getObject((Enum)IBusGdsSirenaContextKeys.SIRENA_LOG_BOOKING_FILE_ADVICE_BUILD_DOCUMENT));
        boolean bl = doTrace = gdsTracingSettings != null && gdsTracingSettings.isActive() && gdsTracingSettings.isSaveSearchTraces();
        if (doBuildDocument || doTrace) {
            GdsTracingItemBuilder builder;
            EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
            Document doc = this.buildDocument(transactions, (SirenaGdsAccount)accountCtr.getEntity());
            if (doBuildDocument) {
                ctx.putObject((Enum)IBusGdsSirenaContextKeys.SIRENA_LOG_DOCUMENT, (Object)doc);
            }
            if (doTrace && (builder = (GdsTracingItemBuilder)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_ITEM_BUILDER)) != null) {
                builder.traceGlobalLogic(new String(doc.getContent()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document buildDocument(List<SirenaGate.GateTransaction> transactions, SirenaGdsAccount account) throws Exception {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             XMLStreamWriter xsw = XSUtil.wrapForPrettyPrinting((XMLStreamWriter)XSUtil.getXMLOutputFactory().createXMLStreamWriter(baos));){
            xsw.writeStartElement("ws-transactions");
            for (SirenaGate.GateTransaction transaction : transactions) {
                xsw.writeStartElement("ws-transaction");
                xsw.writeAttribute("ip", transaction.ip != null ? transaction.ip : "null");
                if (transaction.date != null) {
                    xsw.writeAttribute("date", transaction.date.toString());
                }
                xsw.writeAttribute("timing", Long.toString(transaction.timing));
                xsw.writeAttribute("appId", transaction.appId);
                xsw.writeStartElement("request");
                xsw.writeStartElement("header");
                if (transaction.queryHeader != null) {
                    transaction.queryHeader.toXML(xsw);
                } else {
                    xsw.writeCharacters("[null]");
                }
                xsw.writeEndElement();
                xsw.writeStartElement("data");
                xsw.writeCharacters("");
                if (transaction.queryData != null) {
                    xsw.flush();
                    baos.write(transaction.queryData);
                    baos.flush();
                } else {
                    xsw.writeCharacters("[null]");
                }
                xsw.writeEndElement();
                xsw.writeEndElement();
                xsw.writeStartElement("response");
                xsw.writeStartElement("header");
                if (transaction.answerHeader != null) {
                    transaction.answerHeader.toXML(xsw);
                } else {
                    xsw.writeCharacters("[null]");
                }
                xsw.writeEndElement();
                xsw.writeStartElement("data");
                xsw.writeCharacters("");
                if (transaction.answerData != null) {
                    xsw.flush();
                    MiscUtil.writeBytesWithoutXmlHeader((OutputStream)baos, (byte[])transaction.answerData);
                    baos.flush();
                } else {
                    xsw.writeCharacters("[null]");
                }
                xsw.writeEndElement();
                xsw.writeEndElement();
                xsw.writeEndElement();
            }
            xsw.writeEndElement();
        }
        Document document = new Document();
        document.setContent(baos.toByteArray());
        document.setCheckSum(DigestUtils.md5Hex((byte[])document.getContent()));
        document.setContentType(ContentType.XML);
        document.setCreated(new Date());
        return document;
    }
}

