/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000;

import com.gridnine.xtrip.common.gds.sirena2000.model.SirenaGdsAccount;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.server.gds.sirena2000.Header;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.zip.InflaterInputStream;

public final class MessageIn {
    private static final int MAX_LENGTH = 0x3200000;
    private final Header header;
    private final byte[] rawData;
    private byte[] data;
    private int lastPos;

    MessageIn(Header h) {
        this.header = h;
        if (this.header.getLength() > 0x3200000) {
            throw Xeption.forDeveloper((String)("length too big: " + this.header.getLength()), (Object[])new Object[0]);
        }
        this.rawData = new byte[this.header.getLength()];
    }

    public Header getHeader() {
        return this.header;
    }

    public byte[] getData(SirenaGdsAccount account) throws Exception {
        if (this.data != null || this.rawData == null) {
            return this.data;
        }
        this.data = this.rawData;
        if (this.header.isSymmetricKeyEncryption()) {
            this.data = this.header.getSessionManager().getForDecryption(account, this.header.getSymmetricKeyId()).decrypt(this.rawData);
        }
        if (this.header.isDataCompressed()) {
            int len;
            InflaterInputStream in = new InflaterInputStream(new ByteArrayInputStream(this.data));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buf = new byte[256];
            while ((len = in.read(buf)) != -1) {
                out.write(buf, 0, len);
            }
            this.data = out.toByteArray();
        }
        return this.data;
    }

    int setRawData(byte[] buf, int pos, int size) {
        int result = this.lastPos + size > this.rawData.length ? this.rawData.length - this.lastPos : size;
        System.arraycopy(buf, pos, this.rawData, this.lastPos, result);
        this.lastPos += result;
        return result;
    }

    boolean isRawDataSet() {
        return this.lastPos == this.rawData.length;
    }
}

