/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000;

import com.gridnine.xtrip.common.gds.sirena2000.model.SirenaGdsAccount;
import com.gridnine.xtrip.server.gds.sirena2000.Header;
import com.gridnine.xtrip.server.gds.sirena2000.SSLSessionEntry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.zip.DeflaterOutputStream;

public final class MessageOut {
    private static final int THRESHOLD = 100;
    private final Header header;
    private byte[] rawData;
    private byte[] data;
    private final boolean privileged;

    public MessageOut(Header h, boolean p) {
        this.header = h;
        this.privileged = p;
    }

    Header getHeader() {
        return this.header;
    }

    byte[] getData() {
        return this.data;
    }

    public void setData(SirenaGdsAccount account, byte[] value) throws Exception {
        this.data = value;
        if (this.data.length > 100 && this.header.isDataCompressionAllowed()) {
            int len;
            ByteArrayInputStream in = new ByteArrayInputStream(this.data);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DeflaterOutputStream zipOut = new DeflaterOutputStream(out);
            byte[] buf = new byte[256];
            while ((len = in.read(buf)) != -1) {
                zipOut.write(buf, 0, len);
            }
            zipOut.flush();
            zipOut.finish();
            this.rawData = out.toByteArray();
            if (this.rawData.length >= this.data.length) {
                this.rawData = this.data;
                this.header.setDataCompressed(false);
            } else {
                this.header.setDataCompressed(true);
            }
        } else {
            this.header.setDataCompressed(false);
            this.rawData = this.data;
        }
        if (this.header.isSymmetricKeyEncryption()) {
            SSLSessionEntry entry = this.header.getSessionManager().getForEncryption(account);
            this.header.setSymmetricKeyId(entry.getId());
            this.rawData = entry.encrypt(this.rawData);
        }
        this.header.setLength(this.rawData.length);
    }

    byte[] getRawData() {
        return this.rawData;
    }

    boolean isPrivileged() {
        return this.privileged || this.header.isPublicKeyEncryption() || this.header.isSymmetricKeyEncryption();
    }

    protected MessageOut _clone() {
        MessageOut clone = new MessageOut(this.header._clone(), this.privileged);
        clone.data = this.data;
        clone.rawData = this.rawData;
        return clone;
    }
}

