/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000;

import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.model.GetPnrHistoryAnswer;
import com.gridnine.xtrip.server.gds.sirena2000.model.PnrHistory;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PnrHistoryParser
extends BaseProcessor {
    private static final Pattern P_ENTRY = Pattern.compile("\\((?<number>\\d+)\\) (?<reference>[^ ]+) [^ ]+ [^ ]+ ([\\d]+ )?(?<datetime>[^ ]+ [^ ]+) [^ ]+.*[\r\n]+([^(].*[\\r\\n]+)*");
    private static final DateTimeFormatter DTF = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("ddMMMyy HH:mm:ss").toFormatter(new Locale("ru"));

    public void process(MessageContext ctx) throws Exception {
        GetPnrHistoryAnswer answer = (GetPnrHistoryAnswer)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_ANSWER);
        PnrHistory history = new PnrHistory();
        Matcher m = P_ENTRY.matcher(answer.getPnrHistory());
        while (m.find()) {
            PnrHistory.Entry entry = new PnrHistory.Entry();
            entry.setNumber(Integer.parseInt(m.group("number")));
            entry.setReference(m.group("reference"));
            entry.setDatetime(LocalDateTime.parse(m.group("datetime"), DTF));
            entry.setRawData(m.group());
            history.getEntries().add(entry);
        }
        ctx.putObject((Enum)IBusGdsSirenaContextKeys.PNR_HISTORY, (Object)history);
    }
}

