/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000;

import java.security.GeneralSecurityException;
import java.util.Date;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

public class SSLSessionEntry {
    private final Date expireDate;
    private final int id;
    private final Cipher enc;
    private final Cipher dec;
    private final SecretKey serverKey;
    private final SecretKey clientKey;

    SSLSessionEntry(int sessionId, SecretKey serverKey, SecretKey clientKey, Date _expireDate) throws GeneralSecurityException {
        this.id = sessionId;
        this.serverKey = serverKey;
        this.clientKey = clientKey;
        this.enc = Cipher.getInstance("DES/ECB/PKCS5Padding");
        this.enc.init(1, clientKey);
        this.dec = Cipher.getInstance("DES/ECB/PKCS5Padding");
        this.dec.init(2, serverKey);
        this.expireDate = _expireDate;
    }

    public SecretKey getClientKey() {
        return this.clientKey;
    }

    public SecretKey getServerKey() {
        return this.serverKey;
    }

    public int getId() {
        return this.id;
    }

    boolean isExpired() {
        return this.expireDate.before(new Date());
    }

    public byte[] encrypt(byte[] data) throws GeneralSecurityException {
        return this.enc.doFinal(data);
    }

    public byte[] decrypt(byte[] data) throws GeneralSecurityException {
        return this.dec.doFinal(data);
    }

    public Date getExpireDate() {
        return this.expireDate;
    }
}

