/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000;

import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.server.db.storage.common.LogicalSession;
import com.gridnine.xtrip.server.gds.sirena2000.SSLSessionEntry;
import com.gridnine.xtrip.server.gds.sirena2000.SSLSessionEntryInfoProvider;
import com.gridnine.xtrip.server.gds.sirena2000.SSLSessionEntryStorageProxy;
import com.gridnine.xtrip.server.gds.sirena2000.storage.SSLEntryLockAsset;
import com.gridnine.xtrip.server.gds.sirena2000.storage.SSLSessionEntryAsset;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.crypto.SecretKey;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.log4j.Logger;

public class SSLSessionEntryInfoProviderImpl
implements SSLSessionEntryInfoProvider {
    private static final Logger log = Logger.getLogger(SSLSessionEntryInfoProviderImpl.class);
    private static final String LOCK = ".LOCK";

    @Override
    public SSLSessionEntry load(String clientid) throws Exception {
        SSLSessionEntry entry = null;
        SSLSessionEntryAsset obj = this.loadAsset(clientid);
        if (obj != null) {
            ObjectInputStream oisServerKey = new ObjectInputStream(new ByteArrayInputStream(obj.getServerKey()));
            SecretKey serverKey = (SecretKey)oisServerKey.readObject();
            oisServerKey.close();
            ObjectInputStream oisClientKey = new ObjectInputStream(new ByteArrayInputStream(obj.getClientKey()));
            SecretKey clientKey = (SecretKey)oisClientKey.readObject();
            oisClientKey.close();
            entry = new SSLSessionEntry(obj.getSessionId(), serverKey, clientKey, obj.getExpireDate());
        }
        return entry;
    }

    @Override
    public void save(SSLSessionEntry entry, String clientid) throws Exception {
        SSLSessionEntryAsset obj = this.loadAsset(clientid);
        if (obj == null) {
            obj = new SSLSessionEntryAsset();
        }
        ByteArrayOutputStream baosServer = new ByteArrayOutputStream();
        ObjectOutputStream oosServer = new ObjectOutputStream((OutputStream)baosServer);
        oosServer.writeObject(entry.getServerKey());
        obj.setServerKey(baosServer.toByteArray());
        oosServer.close();
        ByteArrayOutputStream baosClient = new ByteArrayOutputStream();
        ObjectOutputStream oosClient = new ObjectOutputStream((OutputStream)baosClient);
        oosClient.writeObject(entry.getClientKey());
        obj.setClientKey(baosClient.toByteArray());
        oosClient.close();
        obj.setClientId(clientid);
        obj.setSessionId(entry.getId());
        obj.setExpireDate(entry.getExpireDate());
        obj.setModified(new Date());
        SSLSessionEntryStorageProxy.get().save(obj);
    }

    private SSLSessionEntryAsset loadAsset(String clientId) throws Exception {
        try {
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)SSLSessionEntryAsset.Property.clientId.name(), (Object)clientId));
            query.setLimit(1);
            SearchResult<SSLSessionEntryAsset> result = SSLSessionEntryStorageProxy.get().search(SSLSessionEntryAsset.class, query);
            if (result.getData().size() > 0) {
                return (SSLSessionEntryAsset)((Object)result.getData().get(0));
            }
        }
        catch (Exception ex) {
            log.error((Object)"loadSSLSessionEntryInfo() failed", (Throwable)ex);
        }
        return null;
    }

    @Override
    public boolean tryLock(String clientID) throws Exception {
        LogicalSession ms = null;
        try {
            boolean retval = true;
            ms = SSLSessionEntryStorageProxy.get().beginUnitOfWork();
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)SSLEntryLockAsset.Property.name.name(), (Object)(clientID + LOCK)));
            query.setLimit(1);
            SearchResult<SSLEntryLockAsset> result = SSLSessionEntryStorageProxy.get().search(SSLEntryLockAsset.class, query);
            if (result.getData().size() > 0) {
                Date timeout = ((SSLEntryLockAsset)((Object)result.getData().get(0))).getTimeout();
                if (timeout != null && new Date().after(timeout)) {
                    this.saveLock(clientID);
                } else {
                    retval = false;
                }
            } else {
                this.saveLock(clientID);
            }
            SSLSessionEntryStorageProxy.get().endUnitOfWork(ms, true);
            return retval;
        }
        catch (Exception ex) {
            log.error((Object)"failed to lock", (Throwable)ex);
            if (ms != null) {
                SSLSessionEntryStorageProxy.get().cancelUnitOfWork(ms);
            }
            throw ex;
        }
    }

    private void saveLock(String clientID) {
        SSLEntryLockAsset tmp = new SSLEntryLockAsset();
        tmp.setName(clientID + LOCK);
        Date current = new Date();
        tmp.setModified(current);
        tmp.setTimeout(new Date(current.getTime() + 600000L));
        SSLSessionEntryStorageProxy.get().save(tmp);
    }

    @Override
    public void releaseLock(String cliendID) throws Exception {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)SSLEntryLockAsset.Property.name.name(), (Object)(cliendID + LOCK)));
        query.setLimit(1);
        SearchResult<SSLEntryLockAsset> result = SSLSessionEntryStorageProxy.get().search(SSLEntryLockAsset.class, query);
        for (SSLEntryLockAsset a : result.getData()) {
            SSLSessionEntryStorageProxy.get().delete(a);
        }
    }

    @Override
    public void dispose() {
    }
}

