/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000;

import com.gridnine.bof.midoffice.ssl.DatabaseSecurityHelper;
import com.gridnine.xtrip.common.gds.sirena2000.AbstractSirenaQuery;
import com.gridnine.xtrip.common.gds.sirena2000.KeyInfo;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaRequest;
import com.gridnine.xtrip.common.gds.sirena2000.model.SirenaGdsAccount;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.server.SecurityHelper;
import com.gridnine.xtrip.server.gds.sirena2000.HandlerKeyInfo;
import com.gridnine.xtrip.server.gds.sirena2000.Header;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.MessageIn;
import com.gridnine.xtrip.server.gds.sirena2000.MessageOut;
import com.gridnine.xtrip.server.gds.sirena2000.SSLSessionEntry;
import com.gridnine.xtrip.server.gds.sirena2000.SSLSessionEntryInfoProvider;
import com.gridnine.xtrip.server.gds.sirena2000.SSLSessionEntryInfoProviderImpl;
import com.gridnine.xtrip.server.gds.sirena2000.SirenaGate;
import com.gridnine.xtrip.server.gds.sirena2000.SirenaMarshaller;
import com.gridnine.xtrip.server.gds.sirena2000.model.KeyInfoAnswer;
import com.gridnine.xtrip.server.gds.sirena2000.model.KeyInfoQuery;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;

public final class SSLSessionManager {
    private final SirenaGate gate;
    private final ConcurrentHashMap<String, MiscUtil.Pair<SSLSessionEntry, SSLSessionEntry>> mm = new ConcurrentHashMap();
    private final SSLSessionEntryInfoProvider infoProvider;
    private static final String SIGNATURE_ALGORITHM = "SHA1withRSA";
    private static final String ENCRYPTION_ALGORITHM = "RSA/ECB/PKCS1Padding";
    private static final SirenaMarshaller marshaller = new SirenaMarshaller();
    private static final Logger log = Logger.getLogger(SSLSessionManager.class);

    public SSLSessionManager(SirenaGate g) {
        this.gate = g;
        this.infoProvider = new SSLSessionEntryInfoProviderImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SSLSessionEntry getForEncryption(SirenaGdsAccount account) throws Exception {
        while (true) {
            SSLSessionManager sSLSessionManager = this;
            synchronized (sSLSessionManager) {
                MiscUtil.Pair pair = this.mm.get(account.getAccount());
                if (pair == null) {
                    pair = new MiscUtil.Pair(null, null);
                    this.mm.put(account.getAccount(), (MiscUtil.Pair<SSLSessionEntry, SSLSessionEntry>)pair);
                }
                SSLSessionEntry primary = (SSLSessionEntry)pair.getFirst();
                SSLSessionEntry secondary = (SSLSessionEntry)pair.getSecond();
                SSLSessionEntry entry = this.infoProvider.load(account.getAccount());
                if (entry != null && !entry.isExpired()) {
                    if (primary != null && primary.getId() == entry.getId()) {
                        return primary;
                    }
                    secondary = primary;
                    primary = entry;
                    pair.setFirst((Object)primary);
                    pair.setSecond((Object)secondary);
                    return primary;
                }
                if (this.infoProvider.tryLock(account.getAccount())) {
                    try {
                        secondary = primary;
                        primary = SSLSessionManager.create(account, this.gate);
                        this.infoProvider.save(primary, account.getAccount());
                        pair.setFirst((Object)primary);
                        pair.setSecond((Object)secondary);
                        SSLSessionEntry sSLSessionEntry = primary;
                        return sSLSessionEntry;
                    }
                    finally {
                        this.infoProvider.releaseLock(account.getAccount());
                    }
                }
            }
            Thread.sleep(1000L);
        }
    }

    public synchronized SSLSessionEntry getForDecryption(SirenaGdsAccount account, int keyId) throws GeneralSecurityException {
        MiscUtil.Pair pair = this.mm.get(account.getAccount());
        if (pair == null) {
            pair = new MiscUtil.Pair(null, null);
            this.mm.put(account.getAccount(), (MiscUtil.Pair<SSLSessionEntry, SSLSessionEntry>)pair);
        }
        SSLSessionEntry primary = (SSLSessionEntry)pair.getFirst();
        SSLSessionEntry secondary = (SSLSessionEntry)pair.getSecond();
        if (primary != null && primary.getId() == keyId) {
            return primary;
        }
        if (secondary != null && secondary.getId() == keyId) {
            return secondary;
        }
        throw new GeneralSecurityException("no SSL session entry found for ID " + keyId);
    }

    public synchronized void dispose() {
        this.mm.clear();
        if (this.infoProvider != null) {
            this.infoProvider.dispose();
        }
    }

    static void validateKeyInfo() {
    }

    static SSLSessionEntry create(SirenaGdsAccount account, SirenaGate gate) throws Exception {
        log.debug((Object)"SSL handshake BEGIN");
        DatabaseSecurityHelper dbSecHelper = DatabaseSecurityHelper.getInstance();
        Header header = Header.create(Short.parseShort(account.getAccount()), gate.getSessionManager());
        header.setDataCompressionAllowed(false);
        header.setPublicKeyEncryption(true);
        MessageOut req = new MessageOut(header, true);
        KeyInfo keyInfo = SSLSessionManager.loadKeyInfo(account, gate);
        log.debug((Object)"got server/client keys info");
        if (keyInfo.getCurrentClientKeyDigest() == null) {
            throw Xeption.forAdmin((String)"\u0414\u043b\u044f \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f  {0} \u043d\u0435\u0442 \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u0433\u043e \u0432 \u0421\u0438\u0440\u0435\u043d\u0435 \u043a\u043b\u044e\u0447\u0430. \u041f\u0440\u043e\u0432\u0435\u0434\u0438\u0442\u0435 \u043f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u0443 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u043a\u043b\u044e\u0447\u0430", (Object[])new Object[]{account.getName()});
        }
        if (keyInfo.getServerPublicKey() == null) {
            throw new GeneralSecurityException("no public server key returned from server, SSL handshake procedure aborted");
        }
        String alias = account.getAccount();
        if (alias == null) {
            throw new GeneralSecurityException("unknown client key registered on the server, SSL handshake procedure aborted");
        }
        log.debug((Object)("client private/public key pair selected: " + alias));
        SecretKey secretKey = KeyGenerator.getInstance("DES").generateKey();
        byte[] encryptedSecretKey = DatabaseSecurityHelper.encryptData((byte[])keyInfo.getServerPublicKey(), (String)ENCRYPTION_ALGORITHM, (byte[])secretKey.getEncoded());
        log.debug((Object)"generated client-side secret key");
        byte[] sign = dbSecHelper.sign(alias, SIGNATURE_ALGORITHM, encryptedSecretKey);
        byte[] data = new byte[4 + encryptedSecretKey.length + sign.length];
        Header.writeInt(data, 0, encryptedSecretKey.length);
        System.arraycopy(encryptedSecretKey, 0, data, 4, encryptedSecretKey.length);
        System.arraycopy(sign, 0, data, 4 + encryptedSecretKey.length, sign.length);
        req.setData(account, data);
        ValueHolder responseHolder = new ValueHolder();
        gate.doQuery(account, req, (ValueHolder<MessageIn>)responseHolder);
        MessageIn res = (MessageIn)responseHolder.getValue();
        log.debug((Object)"handshake call done");
        if (!res.getHeader().isPublicKeyEncryption()) {
            throw new IOException("got unexpected response from server during SSL handshake procedure");
        }
        if (res.getData(account).length < 6) {
            throw new IOException("got invalid response from server during SSL handshake procedure");
        }
        byte[] keyData = new byte[Header.readInt(res.getData(account), 0)];
        System.arraycopy(res.getData(account), 4, keyData, 0, keyData.length);
        byte[] sign2 = new byte[res.getHeader().getLength() - 4 - keyData.length];
        System.arraycopy(res.getData(account), 4 + keyData.length, sign2, 0, sign2.length);
        if (!SecurityHelper.verify((byte[])keyInfo.getServerPublicKey(), (String)SIGNATURE_ALGORITHM, (byte[])keyData, (byte[])sign2)) {
            throw new GeneralSecurityException("server response signature verification failed during SSL handshake procedure");
        }
        keyData = dbSecHelper.decryptData(alias, ENCRYPTION_ALGORITHM, keyData);
        log.debug((Object)"got server-side secret key");
        log.debug((Object)"initializing session entry");
        SSLSessionEntry result = new SSLSessionEntry(res.getHeader().getSymmetricKeyId(), new SecretKeySpec(keyData, "DES"), secretKey, new DateTime().plusHours(1).toDate());
        log.debug((Object)"SSL handshake END");
        return result;
    }

    public static KeyInfo loadKeyInfo(SirenaGdsAccount account, SirenaGate gate) throws Exception {
        KeyInfoQuery query = new KeyInfoQuery();
        SirenaRequest request = new SirenaRequest();
        request.setQuery((AbstractSirenaQuery)query);
        request.setSecure(false);
        request.setPrivileged(true);
        MessageContext ctx = new MessageContext();
        ctx.putObject((Enum)IBusGdsSirenaContextKeys.SIRENA_REQUEST, (Object)request);
        marshaller.before(ctx);
        byte[] binaryQuery = (byte[])ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_BINARY_REQUEST);
        SirenaGate.GateTransaction gateTransaction = new SirenaGate.GateTransaction();
        byte[] binaryAnswer = gate.doXmlQuery(account, binaryQuery, false, true, gateTransaction);
        ctx.putObject((Enum)IBusGdsSirenaContextKeys.SIRENA_BINARY_RESPONSE, (Object)binaryAnswer);
        marshaller.after(ctx);
        KeyInfoAnswer answer = (KeyInfoAnswer)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_ANSWER);
        KeyInfo result = new KeyInfo();
        HandlerKeyInfo.processResponse(answer, result, account.getAccount());
        return result;
    }
}

