/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000;

import com.gridnine.bof.midoffice.Statistics;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.gds.sirena2000.model.SirenaGateSettings;
import com.gridnine.xtrip.common.gds.sirena2000.model.SirenaGdsAccount;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.server.ServerApplication;
import com.gridnine.xtrip.server.gds.sirena2000.Header;
import com.gridnine.xtrip.server.gds.sirena2000.MessageIn;
import com.gridnine.xtrip.server.gds.sirena2000.MessageOut;
import com.gridnine.xtrip.server.gds.sirena2000.SSLSessionManager;
import com.gridnine.xtrip.server.gds.sirena2000.SirenaErrorsTranslator;
import com.gridnine.xtrip.server.gds.sirena2000.SirenaGateException;
import com.gridnine.xtrip.server.gds.sirena2000.SirenaMarshaller;
import com.gridnine.xtrip.server.gds.sirena2000.model.SirenaEnvelope;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SirenaGate {
    private static final SirenaGateSettings gateSettings = (SirenaGateSettings)EntityStorage.get().resolve(new EntityReference("sirena-gate-settings-id", SirenaGateSettings.class, null)).getEntity();
    static final Logger log = LoggerFactory.getLogger(SirenaGate.class);
    final Queue queue;
    final Thread queueWatcher = new Thread("sirena-queue-watcher"){
        {
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            log.info("queue watcher started");
            long period = (long)SirenaGate.this.maxIdleTime * 1000L;
            if (period <= 0L) {
                period = (long)((SirenaGate.this.timeout > 0 ? SirenaGate.this.timeout : 60) * 2) * 1000L;
            }
            while (true) {
                try {
                    1.sleep(period / 10L);
                }
                catch (InterruptedException ie) {
                    break;
                }
                Queue queue = SirenaGate.this.queue;
                synchronized (queue) {
                    if (!SirenaGate.this.started) {
                        continue;
                    }
                    SirenaGate.this.queue.dump(log);
                    if (!SirenaGate.this.queue.isEmpty()) {
                        continue;
                    }
                    if (System.currentTimeMillis() - SirenaGate.this.queue.getLastActivity() > period) {
                        SirenaGate.this.closeSocket("gate inactivity detected", false);
                    }
                }
            }
            log.info("queue watcher stopped");
        }
    };
    private final SSLSessionManager ssManager;
    private Sender sender;
    private Receiver receiver;
    private Socket socket;
    volatile boolean started;
    private final String host;
    private final int port;
    final int timeout;
    final int maxIdleTime;

    SirenaGate(String address) {
        String url = address.replace("http://", "");
        this.host = url.substring(0, url.indexOf(58));
        this.port = Integer.parseInt(url.substring(url.indexOf(58) + 1));
        this.timeout = gateSettings.getGateTimeout();
        this.maxIdleTime = gateSettings.getGateMaxIdleTime();
        this.ssManager = Environment.isPublished(ServerApplication.class) ? new SSLSessionManager(this) : null;
        this.queue = new Queue(gateSettings.getGateQueueLimit());
    }

    private synchronized void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        if (this.sender == null) {
            this.sender = new Sender();
            this.sender.start();
        }
        if (this.receiver == null) {
            this.receiver = new Receiver();
            this.receiver.start();
        }
        this.queueWatcher.start();
        log.info(String.format("started, host=%s, port=%s, timeout=%s sec", this.host, this.port, this.timeout));
    }

    public SSLSessionManager getSessionManager() {
        return this.ssManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] doXmlQuery(SirenaGdsAccount account, byte[] queryData, boolean secure, boolean privileged, GateTransaction gateTransaction) throws Exception {
        ValueHolder requestHeaderHolder = new ValueHolder();
        ValueHolder responseDataHolder = new ValueHolder();
        ValueHolder responseHeaderHolder = new ValueHolder();
        ValueHolder dateHolder = new ValueHolder();
        ValueHolder timingHolder = new ValueHolder();
        try {
            this.doQuery(account, queryData, secure, privileged, (ValueHolder<Header>)requestHeaderHolder, (ValueHolder<byte[]>)responseDataHolder, (ValueHolder<Header>)responseHeaderHolder, (ValueHolder<Date>)dateHolder, (ValueHolder<Long>)timingHolder);
            byte[] byArray = (byte[])responseDataHolder.getValue();
            return byArray;
        }
        finally {
            gateTransaction.queryData = queryData;
            gateTransaction.queryHeader = (Header)requestHeaderHolder.getValue();
            gateTransaction.answerData = (byte[])responseDataHolder.getValue();
            gateTransaction.answerHeader = (Header)responseHeaderHolder.getValue();
            gateTransaction.date = (Date)dateHolder.getValue();
            if (timingHolder.getValue() != null) {
                gateTransaction.timing = (Long)timingHolder.getValue();
            }
            gateTransaction.appId = Environment.getApplicationId();
            gateTransaction.ip = this.host + ":" + this.port;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doQuery(SirenaGdsAccount account, byte[] data, boolean secure, boolean privileged, ValueHolder<Header> requestHeaderHolder, ValueHolder<byte[]> responseDataHolder, ValueHolder<Header> responseHeaderHolder, ValueHolder<Date> dateHolder, ValueHolder<Long> timingHolder) throws Exception {
        long start;
        Header header;
        block13: {
            header = Header.create(Short.parseShort(account.getAccount()), this.ssManager);
            header.setDataCompressionAllowed(true);
            if (secure) {
                if (account.isSslEnabled()) {
                    header.setSymmetricKeyEncryption(true);
                } else {
                    log.warn("secure calls not enabled");
                }
            }
            requestHeaderHolder.setValue((Object)header);
            MessageOut req = new MessageOut(header, privileged);
            req.setData(account, data);
            dateHolder.setValue((Object)new Date());
            start = System.currentTimeMillis();
            ValueHolder responseHolder = new ValueHolder();
            try {
                this.doQuery(account, req, (ValueHolder<MessageIn>)responseHolder);
            }
            catch (Throwable throwable) {
                block14: {
                    try {
                        MessageIn response = (MessageIn)responseHolder.getValue();
                        if (response == null) break block14;
                        responseHeaderHolder.setValue((Object)response.getHeader());
                        responseDataHolder.setValue((Object)response.getData(account));
                    }
                    catch (Throwable throwable2) {
                        long timing = System.currentTimeMillis() - start;
                        timingHolder.setValue((Object)timing);
                        if (timing > 30000L) {
                            log.warn(String.format("long query mid=%s / %d ms", header.getId(), timing));
                        }
                        throw throwable2;
                    }
                }
                long timing = System.currentTimeMillis() - start;
                timingHolder.setValue((Object)timing);
                if (timing > 30000L) {
                    log.warn(String.format("long query mid=%s / %d ms", header.getId(), timing));
                }
                throw throwable;
            }
            try {
                MessageIn response = (MessageIn)responseHolder.getValue();
                if (response == null) break block13;
                responseHeaderHolder.setValue((Object)response.getHeader());
                responseDataHolder.setValue((Object)response.getData(account));
            }
            catch (Throwable throwable) {
                long timing = System.currentTimeMillis() - start;
                timingHolder.setValue((Object)timing);
                if (timing > 30000L) {
                    log.warn(String.format("long query mid=%s / %d ms", header.getId(), timing));
                }
                throw throwable;
            }
        }
        long timing = System.currentTimeMillis() - start;
        timingHolder.setValue((Object)timing);
        if (timing > 30000L) {
            log.warn(String.format("long query mid=%s / %d ms", header.getId(), timing));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doQuery(SirenaGdsAccount account, MessageOut request, ValueHolder<MessageIn> resultHolder) throws IOException {
        if (!this.started) {
            this.start();
        }
        MessageIn result = null;
        Header header = request.getHeader();
        int firstRequestTimestamp = request.getHeader().getTimestamp();
        try {
            log.debug("put request - " + request.getHeader());
            this.queue.add(request);
            while (this.started) {
                boolean interrupted = false;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                }
                if (!this.queue.contains(header)) {
                    throw new SirenaGateException("\u0441\u0431\u043e\u0439 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0421\u0438\u0440\u0435\u043d\u043e\u0439", new Object[0]);
                }
                result = this.queue.get(header);
                if (result != null) {
                    this.checkTimeOut(firstRequestTimestamp, header);
                    log.debug("found response - " + result.getHeader());
                    if (!result.getHeader().isNotProcessed() || !this.isTryAgainIfNotProcessed(account, result)) {
                        header = null;
                        break;
                    }
                    log.debug(String.format("response %s has 'not-processed' flag", result.getHeader()));
                    MessageOut requestClone = request._clone();
                    this.queue.add(requestClone);
                    header = requestClone.getHeader();
                    continue;
                }
                Throwable error = this.queue.getError(header);
                if (error != null) {
                    header = null;
                    if (error instanceof NoRouteToHostException || error instanceof SocketException) {
                        throw new SirenaGateException("\u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441\u043e \u0448\u043b\u044e\u0437\u043e\u043c \u0421\u0438\u0440\u0435\u043d\u044b", new Object[0]);
                    }
                    if (error instanceof IOException) {
                        throw (IOException)error;
                    }
                    if (error instanceof Xeption) {
                        throw (Xeption)error;
                    }
                    throw new IOException("request failed, error - " + error);
                }
                if (interrupted) {
                    throw Xeption.forEndUser((String)"\u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u043f\u0440\u0435\u0440\u0432\u0430\u043d\u043e", (Object[])new Object[0]);
                }
                this.checkTimeOut(firstRequestTimestamp, header);
            }
            if (result == null) {
                throw new IOException("connection interrupted");
            }
        }
        finally {
            if (header != null) {
                this.queue.remove(header);
            }
            resultHolder.setValue(result);
        }
    }

    private void checkTimeOut(int timeStamp, Header header) {
        if (System.currentTimeMillis() / 1000L - (long)timeStamp > (long)this.timeout) {
            boolean send = !this.queue.timeout(header);
            throw !send ? new SirenaGateException("\u0438\u0441\u0442\u0435\u043a\u043b\u043e \u0432\u0440\u0435\u043c\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u0432 \u0421\u0438\u0440\u0435\u043d\u0443", new Object[0]) : new SirenaGateException("\u0438\u0441\u0442\u0435\u043a\u043b\u043e \u0432\u0440\u0435\u043c\u044f \u043e\u0436\u0438\u0434\u0430\u043d\u0438\u044f \u043e\u0442\u0432\u0435\u0442\u0430 \u0438\u0437 \u0421\u0438\u0440\u0435\u043d\u044b", new Object[0]);
        }
    }

    private boolean isTryAgainIfNotProcessed(SirenaGdsAccount account, MessageIn result) {
        try {
            SirenaEnvelope envelope = new SirenaMarshaller().unwrapEnvelope(result.getData(account));
            if (envelope != null && envelope.getAnswer() != null) {
                if (CollectionUtil.isNotEmpty(envelope.getAnswer().getErrors())) {
                    String msg = envelope.getAnswer().getErrors().get(0).getValue();
                    if (TextUtil.isBlank((String)msg)) {
                        msg = "no message";
                    }
                    String code = envelope.getAnswer().getErrors().get(0).getCode();
                    return SirenaErrorsTranslator.isTryAgainIfNotProcessed(code, msg);
                }
                if (CollectionUtil.isNotEmpty(envelope.getAnswer().getAnswer()) && CollectionUtil.isNotEmpty(envelope.getAnswer().getAnswer().get(0).getErrors())) {
                    String msg = envelope.getAnswer().getAnswer().get(0).getErrors().get(0).getValue();
                    if (TextUtil.isBlank((String)msg)) {
                        msg = "no message";
                    }
                    String code = envelope.getAnswer().getAnswer().get(0).getErrors().get(0).getCode();
                    return SirenaErrorsTranslator.isTryAgainIfNotProcessed(code, msg);
                }
            }
        }
        catch (Exception e) {
            log.error("'not-processed' response check failed", (Throwable)e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Socket getSocket() throws IOException {
        Queue queue = this.queue;
        synchronized (queue) {
            if (!this.started) {
                throw new IOException("gate not started");
            }
            if (this.socket != null) {
                if (this.socket.isConnected() && !this.socket.isClosed()) {
                    return this.socket;
                }
                this.closeSocket("illegal socket state detected", false);
            }
            try {
                this.socket = new Socket(this.host, this.port);
            }
            catch (ConnectException ex) {
                if ("Connection refused".equals(ex.getMessage())) {
                    throw Xeption.forEndUser((String)"\u043e\u0442\u043a\u0430\u0437\u0430\u043d\u043e \u0432 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0441 \u0441\u0438\u0441\u0442\u0435\u043c\u043e\u0439 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0421\u0438\u0440\u0435\u043d\u0430", (Object[])new Object[0]);
                }
                throw ex;
            }
            this.socket.setSoTimeout(5 * this.timeout * 1000);
            this.socket.setKeepAlive(true);
            if (!this.socket.isConnected() || this.socket.isClosed()) {
                throw new IOException("socket connection failed");
            }
            log.debug("socket created");
        }
        return this.socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeSocket(String msg, boolean resetQueue) {
        Queue queue = this.queue;
        synchronized (queue) {
            if (this.socket == null) {
                return;
            }
            try {
                if (!this.socket.isClosed()) {
                    this.socket.shutdownInput();
                    this.socket.shutdownOutput();
                    this.socket.close();
                    log.debug("socket closed");
                }
            }
            catch (IOException ioe) {
                log.error("socket close failed", (Throwable)ioe);
            }
            this.socket = null;
            this.queue.reset();
            log.warn("socket disposed, message: " + msg);
        }
    }

    static final class Queue {
        final Map<Header, MessageOut> requests = new LinkedHashMap<Header, MessageOut>();
        final Map<Header, MessageIn> responses = new LinkedHashMap<Header, MessageIn>();
        final Map<Header, Throwable> errors = new LinkedHashMap<Header, Throwable>();
        final Set<Header> processing = new HashSet<Header>();
        private long lastActivity = System.currentTimeMillis();
        private final int limit;

        Queue(int l) {
            this.limit = l;
        }

        void dump(Logger log) {
            if (!log.isDebugEnabled()) {
                return;
            }
            log.debug(String.format("queue state: requests=%s, responses=%s, errors=%s, processing=%s", this.requests.size(), this.responses.size(), this.errors.size(), this.processing.size()));
        }

        synchronized void reset() {
            this.requests.clear();
            this.responses.clear();
            this.errors.clear();
            this.processing.clear();
        }

        synchronized boolean contains(Header header) {
            return this.requests.containsKey(header) || this.responses.containsKey(header) || this.errors.containsKey(header) || this.processing.contains(header);
        }

        synchronized boolean isEmpty() {
            return this.processing.isEmpty();
        }

        synchronized long getLastActivity() {
            return this.lastActivity;
        }

        synchronized void add(MessageOut msg) {
            int size;
            if (!msg.isPrivileged() && this.limit > 0 && (size = this.requests.size() + this.processing.size()) >= this.limit) {
                log.warn(String.format("GDS gate overloaded: size=%d, limit=%d", size, this.limit));
            }
            this.requests.put(msg.getHeader(), msg);
        }

        synchronized MessageOut getNextToSend() {
            if (this.requests.isEmpty()) {
                return null;
            }
            return this.requests.values().iterator().next();
        }

        synchronized void send(MessageOut msg) {
            if (!this.requests.containsKey(msg.getHeader())) {
                return;
            }
            this.requests.remove(msg.getHeader());
            this.processing.add(msg.getHeader());
            this.lastActivity = System.currentTimeMillis();
            Statistics.stat((String)GdsName.SIRENA.name(), (String)"SND: client-id=%1$s, id=%2$s, date=%3$tF, time=%3$tT, length=%4$s", (Object[])new Object[]{msg.getHeader().getClientId(), msg.getHeader().getId(), (long)msg.getHeader().getTimestamp() * 1000L, msg.getHeader().getLength()});
        }

        synchronized void received(MessageIn msg) {
            if (!this.processing.contains(msg.getHeader())) {
                return;
            }
            this.requests.remove(msg.getHeader());
            this.processing.remove(msg.getHeader());
            this.responses.put(msg.getHeader(), msg);
            this.lastActivity = System.currentTimeMillis();
            Statistics.stat((String)GdsName.SIRENA.name(), (String)"RCV: client-id=%1$s, id=%2$s, date=%3$tF, time=%3$tT, length=%4$s, notProcessed=%5$s", (Object[])new Object[]{msg.getHeader().getClientId(), msg.getHeader().getId(), (long)msg.getHeader().getTimestamp() * 1000L, msg.getHeader().getLength(), msg.getHeader().isNotProcessed()});
        }

        synchronized void error(Header header, Throwable ioe) {
            this.processing.remove(header);
            this.requests.remove(header);
            this.responses.remove(header);
            this.errors.put(header, ioe);
            this.lastActivity = System.currentTimeMillis();
        }

        synchronized MessageIn get(Header header) {
            MessageIn result = this.responses.remove(header);
            if (result != null) {
                this.requests.remove(header);
                this.errors.remove(header);
                this.processing.remove(header);
            }
            return result;
        }

        synchronized Throwable getError(Header header) {
            Throwable result = this.errors.remove(header);
            if (result != null) {
                this.requests.remove(header);
                this.responses.remove(header);
                this.processing.remove(header);
            }
            return result;
        }

        synchronized void remove(Header header) {
            this.requests.remove(header);
            this.responses.remove(header);
            this.errors.remove(header);
            this.processing.remove(header);
        }

        synchronized boolean timeout(Header header) {
            return this.requests.remove(header) != null;
        }
    }

    private final class Receiver
    extends Thread {
        Receiver() {
            super("grs-receiver");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            block4: while (SirenaGate.this.started) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ie) {
                    break;
                }
                if (SirenaGate.this.queue.isEmpty()) continue;
                MessageIn msg = null;
                try {
                    int len;
                    InputStream in = SirenaGate.this.getSocket().getInputStream();
                    byte[] buf = new byte[1000];
                    int pos = 0;
                    int size = 0;
                    while ((len = in.read(buf, pos + size, buf.length - pos - size)) != -1) {
                        if (!SirenaGate.this.started) {
                            return;
                        }
                        size += len;
                        if (msg == null) {
                            if (size < 100) continue;
                            msg = new MessageIn(Header.read(buf, pos, SirenaGate.this.getSessionManager()));
                            pos += 100;
                            size -= 100;
                        }
                        int read = msg.setRawData(buf, pos, size);
                        pos += read;
                        if ((size -= read) == 0) {
                            pos = 0;
                        }
                        if (msg.isRawDataSet()) {
                            SirenaGate.this.queue.received(msg);
                            msg = null;
                            if (SirenaGate.this.queue.isEmpty()) continue block4;
                        }
                        if (pos <= 0) continue;
                        System.arraycopy(buf, pos, buf, 0, size);
                        pos = 0;
                    }
                }
                catch (Throwable t) {
                    if (!SirenaGate.this.started) {
                        return;
                    }
                    if (msg != null) {
                        SirenaGate.this.queue.error(msg.getHeader(), t);
                    }
                    log.error("failed reading data", t);
                    SirenaGate.this.closeSocket("message receive failure", false);
                }
            }
        }
    }

    private final class Sender
    extends Thread {
        Sender() {
            super("grs-sender");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (SirenaGate.this.started) {
                MessageOut msg;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ie) {
                    break;
                }
                while ((msg = SirenaGate.this.queue.getNextToSend()) != null) {
                    if (!SirenaGate.this.started) {
                        return;
                    }
                    try {
                        OutputStream out = SirenaGate.this.getSocket().getOutputStream();
                        byte[] buf = new byte[100];
                        Header.write(buf, 0, msg.getHeader());
                        out.write(buf);
                        out.write(msg.getRawData());
                        out.flush();
                        SirenaGate.this.queue.send(msg);
                    }
                    catch (Throwable t) {
                        Xeption t1 = Xeption.forEndUser((String)"\u0421\u043e\u043a\u0435\u0442 \u0437\u0430\u043a\u0440\u044b\u0442", (Throwable)t, (Object[])new Object[0]);
                        if (!SirenaGate.this.started) {
                            return;
                        }
                        log.error("failed sending message - " + msg.getHeader(), (Throwable)t1);
                        SirenaGate.this.closeSocket("message send failure", false);
                        SirenaGate.this.queue.error(msg.getHeader(), (Throwable)t1);
                    }
                }
            }
        }
    }

    public static class GateTransaction {
        public byte[] queryData;
        public Header queryHeader;
        public byte[] answerData;
        public Header answerHeader;
        public Date date;
        public long timing;
        public String appId;
        public String ip;
    }
}

