/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaRequest;
import com.gridnine.xtrip.common.gds.sirena2000.model.SirenaGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.SirenaGate;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.metrics.Metrics;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SirenaGateInvoker
extends BaseProcessor {
    private final ConcurrentMap<String, SirenaGate> gates = new ConcurrentHashMap<String, SirenaGate>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(MessageContext ctx) throws Exception {
        byte[] answerData;
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        SirenaRequest request = (SirenaRequest)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_REQUEST);
        byte[] queryData = (byte[])ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_BINARY_REQUEST);
        List accountAddresses = (List)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_ACCOUNT_ADDRESSES);
        SirenaGate gate = this.getGate((String)accountAddresses.remove(0));
        SirenaGate.GateTransaction transaction = new SirenaGate.GateTransaction();
        long startTimeInMillis = System.currentTimeMillis();
        try {
            answerData = gate.doXmlQuery((SirenaGdsAccount)accountCtr.getEntity(), queryData, request.isSecure(), request.isPrivileged(), transaction);
        }
        catch (Throwable throwable) {
            try {
                Metrics.get().timingAndEvent(Metrics.key((String[])new String[]{"profiling", "gds", "requests", GdsName.SIRENA.name(), ((SirenaGdsAccount)accountCtr.getEntity()).getName(), MiscUtil.getSimpleClassName(request.getQuery().getClass())}), startTimeInMillis);
            }
            catch (Throwable t) {
                this.log.error("failed sending metrics", t);
            }
            List transactions = (List)ctx.getObject((Enum)IBusGdsSirenaContextKeys.SIRENA_TRANSACTIONS);
            if (transactions != null) {
                transactions.add(transaction);
            }
            throw throwable;
        }
        try {
            Metrics.get().timingAndEvent(Metrics.key((String[])new String[]{"profiling", "gds", "requests", GdsName.SIRENA.name(), ((SirenaGdsAccount)accountCtr.getEntity()).getName(), MiscUtil.getSimpleClassName(request.getQuery().getClass())}), startTimeInMillis);
        }
        catch (Throwable t) {
            this.log.error("failed sending metrics", t);
        }
        List transactions = (List)ctx.getObject((Enum)IBusGdsSirenaContextKeys.SIRENA_TRANSACTIONS);
        if (transactions != null) {
            transactions.add(transaction);
        }
        ctx.putObject((Enum)IBusGdsSirenaContextKeys.SIRENA_BINARY_RESPONSE, (Object)answerData);
    }

    private SirenaGate getGate(String address) {
        SirenaGate earlier;
        String url = address.replace("http://", "");
        SirenaGate gate = null;
        gate = (SirenaGate)this.gates.get(url);
        if (gate == null && (earlier = this.gates.putIfAbsent(url, gate = new SirenaGate(url))) != null) {
            return earlier;
        }
        return gate;
    }
}

