/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.HashSet;
import java.util.Map;

public class SirenaLogBookingFileAdvice
extends BaseAdvice {
    private String docName;

    public void configure(Map<String, String> params) throws Exception {
        this.docName = params.get("doc-name");
    }

    public void before(MessageContext ctx) throws Exception {
        ctx.putObject((Enum)IBusGdsSirenaContextKeys.SIRENA_LOG_BOOKING_FILE_ADVICE_BUILD_DOCUMENT, (Object)Boolean.TRUE);
    }

    public void after(MessageContext ctx) throws Exception {
        Document doc = (Document)ctx.getObject((Enum)IBusGdsSirenaContextKeys.SIRENA_LOG_DOCUMENT);
        if (doc != null) {
            EntityContainer gdsAccountCtr;
            doc.setName(this.docName + ".xml");
            doc.setTitle(this.docName + " transactions");
            EntityContainer bfCtr = (EntityContainer)ctx.getObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
            if (bfCtr != null) {
                doc.setOwner(bfCtr.toReference());
            }
            if ((gdsAccountCtr = (EntityContainer)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT)) != null) {
                doc.setTitle(doc.getTitle() + String.format(" (%s)", ((BaseGdsAccount)gdsAccountCtr.getEntity()).getName()));
            } else {
                doc.setTitle(doc.getTitle() + String.format(" (%s)", GdsName.SIRENA.name()));
            }
            HashSet<Document> documents = (HashSet<Document>)ctx.getObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_DOCUMENTS);
            if (documents == null) {
                documents = new HashSet<Document>();
                ctx.putObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_DOCUMENTS, documents);
            }
            documents.add(doc);
        }
    }
}

