/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000;

import com.gridnine.xtrip.common.gds.sirena2000.AbstractSirenaQuery;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaRequest;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.SirenaErrorsTranslator;
import com.gridnine.xtrip.server.gds.sirena2000.model.SirenaEnvelope;
import com.gridnine.xtrip.server.gds.sirena2000.model.SirenaModelClasses;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.naming.NoNameCoder;
import com.thoughtworks.xstream.io.xml.CompactWriter;
import com.thoughtworks.xstream.io.xml.Xpp3Driver;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class SirenaMarshaller
extends BaseAdvice {
    private final XStream xstream = new XStream((HierarchicalStreamDriver)new Xpp3Driver((NameCoder)new NoNameCoder()));
    private static final String EXCEPTION_KEY = SirenaMarshaller.class.getName() + ".exception";

    public SirenaMarshaller() {
        this.xstream.ignoreUnknownElements();
        this.xstream.processAnnotations(SirenaModelClasses.CLASSES);
        this.xstream.aliasSystemAttribute(null, "class");
        this.xstream.allowTypes(SirenaModelClasses.CLASSES);
    }

    private static SirenaEnvelope wrapEnvelope(AbstractSirenaQuery query) {
        SirenaEnvelope envelope = new SirenaEnvelope();
        SirenaEnvelope.Query q = new SirenaEnvelope.Query();
        q.getQuery().add(query);
        envelope.setQuery(q);
        return envelope;
    }

    SirenaEnvelope unwrapEnvelope(byte[] data) throws IOException {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(data);){
            SirenaEnvelope sirenaEnvelope = (SirenaEnvelope)this.xstream.fromXML((InputStream)bais);
            return sirenaEnvelope;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void before(MessageContext ctx) throws Exception {
        SirenaRequest request = (SirenaRequest)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_REQUEST);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             OutputStreamWriter osw = new OutputStreamWriter(baos);
             CompactWriter cw = new CompactWriter((Writer)osw, (NameCoder)new NoNameCoder());){
            this.xstream.marshal((Object)SirenaMarshaller.wrapEnvelope(request.getQuery()), (HierarchicalStreamWriter)cw);
        }
        ctx.putObject((Enum)IBusGdsSirenaContextKeys.SIRENA_BINARY_REQUEST, (Object)baos.toByteArray());
    }

    public boolean handleException(Throwable e, MessageContext ctx) throws Exception {
        ctx.putObject(EXCEPTION_KEY, (Object)Boolean.TRUE);
        return super.handleException(e, ctx);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void after(MessageContext ctx) throws Exception {
        if (!Boolean.TRUE.equals(ctx.getObject(EXCEPTION_KEY))) {
            byte[] answerData = (byte[])ctx.removeObject((Enum)IBusGdsSirenaContextKeys.SIRENA_BINARY_RESPONSE);
            SirenaEnvelope envelope = this.unwrapEnvelope(answerData);
            if (envelope.getAnswer().getAnswer() != null && !envelope.getAnswer().getAnswer().isEmpty()) {
                ctx.putObject((Enum)IBusGdsSirenaContextKeys.SIRENA_ANSWER, (Object)envelope.getAnswer().getAnswer().get(0));
                ctx.putObject((Enum)IBusGdsSirenaContextKeys.SIRENA_ANSWER_PULT, (Object)envelope.getAnswer().getPult());
                return;
            } else {
                if (envelope.getAnswer().getErrors() == null || envelope.getAnswer().getErrors().isEmpty()) throw Xeption.forDeveloper((String)"no answer, no errors", (Object[])new Object[0]);
                String msg = envelope.getAnswer().getErrors().get(0).getValue();
                if (TextUtil.isBlank((String)msg)) {
                    msg = "no message";
                }
                String code = envelope.getAnswer().getErrors().get(0).getCode();
                SirenaErrorsTranslator.translate(code, msg, ctx);
            }
            return;
        } else {
            ctx.removeObject(EXCEPTION_KEY);
        }
    }
}

