/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000;

import com.gridnine.xtrip.common.gds.model.AircraftDeckLocation;
import com.gridnine.xtrip.common.gds.model.AircraftSeatIndicator;
import com.gridnine.xtrip.common.gds.model.AncillaryFeeType;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.MCOReservationRequestStatus;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.server.gds.sirena2000.model.BookingQuery;
import com.gridnine.xtrip.server.gds.sirena2000.model.Pnr;
import com.gridnine.xtrip.server.gds.sirena2000.model.SeatMapAnswer;
import com.gridnine.xtrip.server.gds.sirena2000.model.Svc;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;

public class SirenaServerHelper {
    private static Map<String, AncillaryFeeType> ancillaryFeeTypesMap = new HashMap<String, AncillaryFeeType>();
    private static final Map<MCOReservationRequestStatus, Integer> MCOReservationRequestStatusPriorityMap;

    public static AncillaryFeeType convertAncillaryFeeTypeFromGds(String gdsValue) {
        return ancillaryFeeTypesMap.get(gdsValue);
    }

    public static Date parseDate(Pnr.Segments.Segment.Location location) throws Exception {
        return new SimpleDateFormat("dd.MM.yy HH:mm").parse(location.getDate() + ' ' + location.getTime());
    }

    public static Pnr.Passengers.Passenger getPassenger(Pnr pnr, Traveller traveller, int sliceIdx) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy");
        for (Pnr.Passengers.Passenger passenger : pnr.getPassengers().getPassengers()) {
            if (!passenger.getName().equalsIgnoreCase(SirenaHelper.buildName((Traveller)traveller, (int)sliceIdx)) || !passenger.getSurname().equalsIgnoreCase(SirenaHelper.buildSurname((Traveller)traveller)) || !passenger.getSex().equalsIgnoreCase(Gender.FEMALE == traveller.getPassport().getGender() ? "female" : "male") || !passenger.getBirthdate().equalsIgnoreCase(df.format(traveller.getPassport().getBirthday())) || !passenger.getDoccode().equalsIgnoreCase(SirenaHelper.idCardType2str((PassportType)traveller.getPassport().getType())) || !passenger.getDoc().equalsIgnoreCase(SirenaHelper.fixDocNumberForPNR((String)traveller.getPassport().getNumber()))) continue;
            return passenger;
        }
        throw Xeption.forDeveloper((String)("passenger not found, sliceIdx = " + sliceIdx + " traveller=" + XSUtil.toString((XSSerializable)traveller)), (Object[])new Object[0]);
    }

    public static TimeZone getSirenaTimeZone() {
        return TimeZone.getTimeZone("Europe/Moscow");
    }

    public static AircraftDeckLocation code2AircraftDeckLocation(String code) {
        if (StringUtils.isBlank((String)code)) {
            return null;
        }
        switch (code) {
            case "M": {
                return AircraftDeckLocation.MAIN;
            }
            case "U": {
                return AircraftDeckLocation.UPPER;
            }
            case "L": {
                return AircraftDeckLocation.LOWER;
            }
        }
        throw Xeption.forDeveloper((String)"unexpected code {0}", (Object[])new Object[]{code});
    }

    public static void addAisleToChairProps(SeatMapAnswer.Deck.Cabine.Row.Chair chair) {
        chair.setProps("aisle," + chair.getProps());
    }

    public static AircraftSeatIndicator gdsSeatProperty2SeatIndicator(String gdsSeatProperty) {
        AircraftSeatIndicator result = null;
        switch (gdsSeatProperty) {
            case "AL": 
            case "A": 
            case "aisle": 
            case "aisle_seat": {
                result = AircraftSeatIndicator.AISLE_SEAT;
                break;
            }
            case "W": 
            case "window": 
            case "window_seat": {
                result = AircraftSeatIndicator.WINDOW_SEAT;
                break;
            }
            case "K": 
            case "bulkhead": {
                result = AircraftSeatIndicator.BULKHEAD_SEAT;
                break;
            }
            case "E": {
                result = AircraftSeatIndicator.EXIT_ROW_SEAT;
                break;
            }
            case "I": 
            case "infant": {
                result = AircraftSeatIndicator.LAP_CHILD;
                break;
            }
            case "L": 
            case "legroom": {
                result = AircraftSeatIndicator.LEG_SPACE_SEAT;
                break;
            }
            case "1D": {
                result = AircraftSeatIndicator.RESTRICTED_DECLINE;
            }
        }
        return result;
    }

    public static MCOReservationRequestStatus actionCode2MCOReservationRequestStatus(String actionCode) {
        switch (actionCode) {
            case "HN": 
            case "NN": 
            case "\u0422\u0422": 
            case "\u041d\u0418": {
                return MCOReservationRequestStatus.PENDING;
            }
            case "HD": 
            case "HK": 
            case "KK": 
            case "KD": 
            case "\u041d\u041a": 
            case "\u041a\u041a": {
                return MCOReservationRequestStatus.CONFIRMED;
            }
            case "HE": 
            case "HC": 
            case "OH": 
            case "UC": 
            case "UN": 
            case "HX": 
            case "XX": 
            case "HO": 
            case "\u0423\u041d": 
            case "\u041d\u0415": 
            case "\u041d\u0421": 
            case "\u041e\u041d": 
            case "\u041d\u0425": 
            case "\u0425\u0425": {
                return MCOReservationRequestStatus.REJECTED;
            }
        }
        throw Xeption.forDeveloper((String)String.format("unknown actionCode %s", actionCode), (Object[])new Object[0]);
    }

    public static MCOReservationRequestStatus getMCOReservationRequestStatusForRelatedProducts(List<Svc> svcList) {
        return svcList.stream().map(svc -> SirenaServerHelper.actionCode2MCOReservationRequestStatus(svc.getStatus())).min(Comparator.comparing(MCOReservationRequestStatusPriorityMap::get)).orElseThrow(() -> Xeption.forDeveloper((String)"Not found MCOReservationRequestStatus", (Object[])new Object[0]));
    }

    public static void addSsrSectionIfMissing(BookingQuery query) {
        if (query.getSpecialServices() == null) {
            BookingQuery.SpecialServices ss = new BookingQuery.SpecialServices();
            BookingQuery.SpecialServices.Ssrs ssrs = new BookingQuery.SpecialServices.Ssrs();
            ssrs.setSsrs(new ArrayList<BookingQuery.SpecialServices.Ssrs.Ssr>());
            ss.setSsrs(ssrs);
            query.setSpecialServices(ss);
        }
    }

    static {
        ancillaryFeeTypesMap.put("P", AncillaryFeeType.BAGGAGE);
        ancillaryFeeTypesMap.put("F", AncillaryFeeType.PREFERRED_SEATING);
        MCOReservationRequestStatusPriorityMap = new HashMap<MCOReservationRequestStatus, Integer>();
        MCOReservationRequestStatusPriorityMap.put(MCOReservationRequestStatus.REJECTED, 1);
        MCOReservationRequestStatusPriorityMap.put(MCOReservationRequestStatus.PENDING, 2);
        MCOReservationRequestStatusPriorityMap.put(MCOReservationRequestStatus.CONFIRMED, 3);
    }
}

