/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.addFFInfo;

import com.gridnine.xtrip.common.gds.sirena2000.AbstractSirenaQuery;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaHelper;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaRequest;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.profile.AirlineBonusCard;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.addFFInfo.AddFFInfoRequestParameters;
import com.gridnine.xtrip.server.gds.sirena2000.addFFInfo.FFInfoHelper;
import com.gridnine.xtrip.server.gds.sirena2000.model.AddFfInfoQuery;
import com.gridnine.xtrip.server.gds.sirena2000.model.Pnr;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.List;

public class AddFFInfoRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        AddFFInfoRequestParameters parameters = (AddFFInfoRequestParameters)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.ADD_FF_INFO_REQUEST_PARAMETERS);
        ctx.putObject((Enum)IBusGdsSirenaContextKeys.SIRENA_REQUEST, this.buildRequest(parameters));
    }

    private SirenaRequest<AddFfInfoQuery> buildRequest(AddFFInfoRequestParameters parameters) {
        SirenaRequest request = new SirenaRequest();
        request.setQuery((AbstractSirenaQuery)this.buildQuery(parameters));
        request.setSecure(false);
        request.setPrivileged(false);
        return request;
    }

    private AddFfInfoQuery buildQuery(AddFFInfoRequestParameters parameters) {
        AddFfInfoQuery query = new AddFfInfoQuery();
        query.setRegnum(parameters.getRegnum());
        query.setSurname(parameters.getSurname());
        boolean hasCardsAdded = false;
        for (Traveller traveller : parameters.getTravellers()) {
            for (AirlineBonusCard card : parameters.getCards(traveller)) {
                List<String> segIds = FFInfoHelper.getSegmentsIdsByAirlineCode(parameters.getSegments(), (DictionaryReference<Airline>)card.getAirline());
                if (segIds.isEmpty()) {
                    this.log.error("No applicable segment id found for FF card " + card.getAirline().getCode() + " " + card.getNumber());
                    continue;
                }
                String travellerId = this.getTravellerId(traveller, parameters.getPassengers());
                if (travellerId == null) {
                    this.log.error("No traveller id for " + traveller.getName());
                    continue;
                }
                String cardNumber = card.getNumber();
                if (cardNumber == null) {
                    this.log.error("No card number for FF card " + card.getAirline().getCode());
                    continue;
                }
                AddFfInfoQuery.Passenger passenger = new AddFfInfoQuery.Passenger();
                passenger.setId(travellerId);
                for (String id : segIds) {
                    AddFfInfoQuery.Passenger.Segment segment = new AddFfInfoQuery.Passenger.Segment();
                    segment.setId(id);
                    passenger.getSegments().add(segment);
                }
                AddFfInfoQuery.Passenger.FreqFlierId freqFlierId = new AddFfInfoQuery.Passenger.FreqFlierId();
                freqFlierId.setValue(cardNumber);
                passenger.setFreqFlierId(freqFlierId);
                hasCardsAdded = true;
                query.getPassengers().add(passenger);
            }
        }
        if (!hasCardsAdded) {
            throw Xeption.forAdmin((String)("No applicable cards were found for any traveller in " + parameters.getRegnum()), (Object[])new Object[0]);
        }
        return query;
    }

    private String getTravellerId(Traveller traveller, List<Pnr.Passengers.Passenger> psgrs) {
        String passType = SirenaHelper.idCardType2str((PassportType)traveller.getPassport().getType());
        for (Pnr.Passengers.Passenger psgr : psgrs) {
            String xmlpassportNumber = psgr.getDoc();
            String xmlpassportType = psgr.getDoccode();
            if (!xmlpassportNumber.equalsIgnoreCase(traveller.getPassport().getNumber()) || !xmlpassportType.equalsIgnoreCase(passType)) continue;
            return psgr.getId();
        }
        this.log.warn("logic error! passenger id not found");
        return "";
    }
}

