/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.afs20;

import com.gridnine.xtrip.common.gds.sirena2000.AbstractSirenaQuery;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaHelper;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaRequest;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.model.AbstractPricingQuery;
import com.gridnine.xtrip.server.gds.sirena2000.model.PricingRouteQuery;
import com.gridnine.xtrip.server.gds.sirena2000.pricingRoute.PricingRouteHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public class SirenaAfsPricingRouteRequestBuilder
extends BaseProcessor {
    private boolean setClass;
    private boolean setSubclass;
    private boolean setFlight;
    private boolean setDirect;

    public void configure(Map<String, String> parameters) {
        if (parameters.containsKey("setClass")) {
            this.setClass = Boolean.parseBoolean(parameters.get("setClass"));
        }
        if (parameters.containsKey("setSubclass")) {
            this.setSubclass = Boolean.parseBoolean(parameters.get("setSubclass"));
        }
        if (parameters.containsKey("setFlight")) {
            this.setFlight = Boolean.parseBoolean(parameters.get("setFlight"));
        }
        if (parameters.containsKey("setDirect")) {
            this.setDirect = Boolean.parseBoolean(parameters.get("setDirect"));
        }
    }

    public void process(MessageContext ctx) throws Exception {
        Collection products = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.PRODUCTS);
        SirenaRequest request = new SirenaRequest();
        request.setQuery((AbstractSirenaQuery)new PricingRouteQuery());
        request.setSecure(false);
        request.setPrivileged(false);
        Product aProduct = (Product)products.iterator().next();
        for (SegmentTariff st : aProduct.getSegmentTariffs()) {
            for (Segment seg : st.getSegments()) {
                AbstractPricingQuery.Segment segment = new AbstractPricingQuery.Segment();
                segment.setDeparture(SirenaHelper.getNativeCode((DictionaryReference)seg.getDepartureLocation()));
                segment.setArrival(SirenaHelper.getNativeCode((DictionaryReference)seg.getArriveLocation()));
                segment.setDate(PricingRouteHelper.DF.format(seg.getStartDate()));
                if (this.setClass) {
                    segment.setClazz(SirenaHelper.serviceClassToString((ClassOfService)DictHelper.findClassOfService((Segment)seg, (Date)aProduct.getIssueDate())));
                }
                if (this.setSubclass) {
                    segment.setSubclass(seg.getClassOfSvcCode());
                }
                if (this.setFlight) {
                    segment.setCompany(SirenaHelper.getNativeCode((DictionaryReference)seg.getAirline()));
                    segment.setNum(seg.getFlightNo());
                }
                segment.setDirect(this.setDirect);
                ((PricingRouteQuery)request.getQuery()).getSegments().add(segment);
            }
        }
        AbstractPricingQuery.Passenger passenger = new AbstractPricingQuery.Passenger();
        passenger.setCode(SirenaHelper.getNativeCode((DictionaryReference)aProduct.getPassengerType()));
        passenger.setCount(1);
        ((PricingRouteQuery)request.getQuery()).getPassengers().add(passenger);
        ctx.putObject((Enum)IBusGdsSirenaContextKeys.SIRENA_REQUEST, (Object)request);
    }
}

