/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.afs20;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaHelper;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.pricingRoute.PricingRouteHelper;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SirenaAfsReservationProductBatchesProvider
extends BaseTargetsProvider<List<Product>> {
    private boolean setClass;
    private boolean setSubclass;
    private boolean setFlight;
    private boolean setDirect;

    public void configure(Map<String, String> parameters) {
        if (parameters.containsKey("setClass")) {
            this.setClass = Boolean.parseBoolean(parameters.get("setClass"));
        }
        if (parameters.containsKey("setSubclass")) {
            this.setSubclass = Boolean.parseBoolean(parameters.get("setSubclass"));
        }
        if (parameters.containsKey("setFlight")) {
            this.setFlight = Boolean.parseBoolean(parameters.get("setFlight"));
        }
        if (parameters.containsKey("setDirect")) {
            this.setDirect = Boolean.parseBoolean(parameters.get("setDirect"));
        }
    }

    public Collection<List<Product>> getTargets(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Collection productUids = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.AFS_PRODUCT_UIDS_TO_UPDATE);
        return reservation.getProducts().stream().filter(bp -> productUids.contains(bp.getUid())).map(bp -> (Product)bp).filter(prod -> prod.getProductCategory() == ProductCategory.AIR).collect(Collectors.groupingBy(prod -> this.buildProductKey((Product)prod))).values();
    }

    private Object buildProductKey(Product prod) {
        ArrayList<Object> keys = new ArrayList<Object>();
        for (SegmentTariff st : prod.getSegmentTariffs()) {
            for (Segment seg : st.getSegments()) {
                ArrayList<Object> segKeys = new ArrayList<Object>();
                segKeys.add(SirenaHelper.getNativeCode((DictionaryReference)seg.getDepartureLocation()));
                segKeys.add(SirenaHelper.getNativeCode((DictionaryReference)seg.getArriveLocation()));
                segKeys.add(PricingRouteHelper.DF.format(seg.getStartDate()));
                if (this.setClass) {
                    segKeys.add(SirenaHelper.serviceClassToString((ClassOfService)DictHelper.findClassOfService((Segment)seg, (Date)prod.getIssueDate())));
                }
                if (this.setSubclass) {
                    segKeys.add(seg.getClassOfSvcCode());
                }
                if (this.setFlight) {
                    segKeys.add(SirenaHelper.getNativeCode((DictionaryReference)seg.getAirline()));
                    segKeys.add(seg.getFlightNo());
                }
                segKeys.add(this.setDirect);
                keys.add(segKeys);
            }
        }
        keys.add(SirenaHelper.getNativeCode((DictionaryReference)prod.getPassengerType()));
        return keys;
    }
}

