/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.afs20;

import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.profile.AFSType;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.ibus.afs20.IBusGdsAfsKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SirenaP3DProcessor
extends BaseProcessor {
    private static final Pattern P_AD = Pattern.compile("/?(AD|CO|NLMK)([0-9]+)");

    public void process(MessageContext ctx) throws Exception {
        BigDecimal undiscountedFare;
        Matcher m;
        Product product = (Product)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.PRODUCT);
        String fareBasis = ((Segment)((SegmentTariff)product.getSegmentTariffs().get(0)).getSegments().get(0)).getFareBasis();
        BigDecimal equivalentFare = AirProductHelper.getEquivalentFare((Product)product);
        if (equivalentFare == null) {
            equivalentFare = BigDecimal.ZERO;
        }
        if ((m = P_AD.matcher(fareBasis)).find()) {
            BigDecimal p = new BigDecimal(m.group(2));
            if (p.compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal d = BigDecimal.ONE.subtract(p.divide(new BigDecimal(100), equivalentFare.scale(), RoundingMode.HALF_UP));
                undiscountedFare = equivalentFare.divide(d, 0, RoundingMode.HALF_UP);
            } else {
                undiscountedFare = equivalentFare;
            }
        } else {
            undiscountedFare = equivalentFare;
        }
        BigDecimal taxes = AirProductHelper.calculateTaxesEquivalentAmount((Product)product);
        if (taxes != null) {
            undiscountedFare = undiscountedFare.add(taxes);
        }
        AFSType afsType = (AFSType)ctx.getMandatoryObject((Enum)IBusGdsAfsKeys.AFS_TYPE);
        Boolean isTicketing = (Boolean)ctx.getMandatoryObject((Enum)IBusGdsAfsKeys.AFS_IS_TICKETING);
        StatisticsHelper.smartSetPricingAfsValue((Product)product, (AFSType)afsType, (boolean)isTicketing, (Double)undiscountedFare.doubleValue());
    }
}

