/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.afs20;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.profile.AFSType;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.ibus.afs20.IBusGdsAfsKeys;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.afs20.SirenaAfsHelper;
import com.gridnine.xtrip.server.gds.sirena2000.model.AbstractPricingAnswer;
import com.gridnine.xtrip.server.gds.sirena2000.model.PricingRouteAnswer;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class SirenaPricingResponseParser
extends BaseProcessor {
    private String variantPrice;
    private boolean withTaxes;

    public void configure(Map<String, String> parameters) {
        this.variantPrice = parameters.get("variant-price");
        this.withTaxes = Boolean.parseBoolean(parameters.get("with-taxes"));
    }

    public void process(MessageContext ctx) throws Exception {
        AbstractPricingAnswer.Variant variant;
        PricingRouteAnswer response = (PricingRouteAnswer)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_ANSWER);
        List<AbstractPricingAnswer.Variant> variants = response.getVariants();
        if (this.variantPrice.equals("max")) {
            variant = variants.get(variants.size() - 1);
        } else if (this.variantPrice.equals("min")) {
            variant = variants.get(0);
        } else {
            throw Xeption.forDeveloper((String)"misconfiguration, variant-price should be in ('min', 'max') but was {0}", (Object[])new Object[]{this.variantPrice});
        }
        Double value = SirenaAfsHelper.getVariantPrice(variant, this.withTaxes).doubleValue();
        AFSType afsType = (AFSType)ctx.getMandatoryObject((Enum)IBusGdsAfsKeys.AFS_TYPE);
        Boolean isTicketing = (Boolean)ctx.getMandatoryObject((Enum)IBusGdsAfsKeys.AFS_IS_TICKETING);
        Collection products = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.PRODUCTS);
        for (Product product : products) {
            StatisticsHelper.smartSetPricingAfsValue((Product)product, (AFSType)afsType, (boolean)isTicketing, (Double)value);
        }
    }
}

