/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.cancelAncillaryFees;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.sirena2000.AbstractSirenaQuery;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaRequest;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.model.OrderAnswer;
import com.gridnine.xtrip.server.gds.sirena2000.model.Regnum;
import com.gridnine.xtrip.server.gds.sirena2000.model.Svc;
import com.gridnine.xtrip.server.gds.sirena2000.model.SvcDelQuery;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class DeleteSvcQueryBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        OrderAnswer orderAnswer = (OrderAnswer)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_ANSWER);
        Collection products = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BASE_PRODUCTS);
        ctx.putObject((Enum)IBusGdsSirenaContextKeys.SIRENA_REQUEST, this.buildRequest(orderAnswer, products));
    }

    private SirenaRequest<SvcDelQuery> buildRequest(OrderAnswer orderAnswer, Collection<Product> products) {
        SirenaRequest request = new SirenaRequest();
        SvcDelQuery query = new SvcDelQuery();
        String[] svcIds = (String[])products.stream().map(Product::getGdsId).flatMap(ids -> Arrays.stream(ids.split(","))).filter(id -> this.containsSvc(orderAnswer, (String)id)).toArray(String[]::new);
        query.setSvc(new ArrayList<Svc>(svcIds.length));
        for (String id2 : svcIds) {
            Svc svc = new Svc();
            svc.setId(id2);
            query.getSvc().add(svc);
        }
        Regnum regnum = new Regnum();
        regnum.setVersion(orderAnswer.getPnr().getVersion());
        regnum.setValue(orderAnswer.getPnr().getRegnum());
        query.setRegnum(regnum);
        request.setQuery((AbstractSirenaQuery)query);
        request.setSecure(false);
        request.setPrivileged(false);
        return request;
    }

    private boolean containsSvc(OrderAnswer orderAnswer, String svcId) {
        List<Svc> svcs = orderAnswer.getPnr().getSvcs().getSvcs();
        for (Svc svc : svcs) {
            if (!svcId.equals(svc.getId())) continue;
            return true;
        }
        throw Xeption.forDeveloper((String)String.format("svc with id = %s is not found in OrderAnswer", svcId), (Object[])new Object[0]);
    }
}

