/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.cityFilter;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.BaseAirGdsAccount;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dict.AirlineCityInfo;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class CityFilterAirlineCityInfoCreator
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Collection airlineCityInfos = DictionaryCache.get().getAll(AirlineCityInfo.class).values();
        AirlineCityInfo airlineCityInfo = null;
        EntityContainer gdsAccountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        BaseAirGdsAccount gdsAccount = (BaseAirGdsAccount)gdsAccountCtr.getEntity();
        DictionaryReference airlineRef = gdsAccount.getSearchCityFilterAirline();
        for (AirlineCityInfo aci : airlineCityInfos) {
            if (!aci.getAirline().equals((Object)airlineRef)) continue;
            airlineCityInfo = aci;
            break;
        }
        if (airlineCityInfo == null) {
            airlineCityInfo = new AirlineCityInfo();
            airlineCityInfo.setAirline(airlineRef);
        }
        Set citiesCodes = (Set)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.CITY_FILTER_CITIES);
        HashMap accMap = (HashMap)ctx.getObject((Enum)IBusGdsSirenaContextKeys.MISSED_CITY_CODES);
        if (accMap == null) {
            accMap = new HashMap();
            ctx.putObject((Enum)IBusGdsSirenaContextKeys.MISSED_CITY_CODES, accMap);
        }
        HashSet<String> missedCityCodes = null;
        HashSet<GeoLocationReference> geoLocations = new HashSet<GeoLocationReference>();
        for (String code : citiesCodes) {
            GeoLocation city = DictHelper.findCity((DictionaryReference)SirenaHelper.resolveNativeCode(GeoLocation.class, (String)code));
            if (city == null) {
                if (!accMap.containsKey(airlineRef.getCode())) {
                    missedCityCodes = new HashSet<String>();
                    accMap.put(airlineRef.getCode(), missedCityCodes);
                }
                missedCityCodes.add(code);
                continue;
            }
            geoLocations.add(city.toReference());
        }
        Set cities = airlineCityInfo.getCities();
        boolean isChanged = cities.retainAll(geoLocations);
        boolean bl = isChanged = cities.addAll(geoLocations) || isChanged;
        if (isChanged) {
            airlineCityInfo.setDataSource("SirenaTask-cityFilter");
            DictionaryStorage.get().save((BaseDictionary)airlineCityInfo);
        }
    }
}

