/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.cityFilter;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.mail.MailAddress;
import com.gridnine.xtrip.common.model.mail.MailDocument;
import com.gridnine.xtrip.common.model.mail.MailPart;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.mail.MailSender;
import java.util.Map;
import java.util.Set;

public class MissedCityCodesMailSender
extends BaseProcessor {
    public void process(MessageContext ctx) {
        Map accMap = (Map)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.MISSED_CITY_CODES);
        MailSender mailSender = (MailSender)Environment.getPublished(MailSender.class);
        MailDocument md = new MailDocument();
        md.setFrom(mailSender.getDefaultFromAddress());
        String emailTo = (String)ctx.getMandatoryObject("emailTo");
        MailAddress ma = new MailAddress();
        ma.setAddress(emailTo);
        md.getTo().add(ma);
        md.setSubject("\u041f\u0443\u043d\u043a\u0442\u044b \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0430\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0439");
        MailPart body = new MailPart();
        body.setContentType(ContentType.TEXT);
        String data = this.getBodyData(accMap);
        body.setData(data.getBytes());
        md.setBody(body);
        mailSender.send(md);
    }

    public String getBodyData(Map<String, Set<String>> accMap) {
        StringBuilder sb = new StringBuilder();
        sb.append("\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0435 \u0432 \u0431\u0430\u0437\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u043a\u043e\u0434\u044b \u0433\u043e\u0440\u043e\u0434\u043e\u0432:").append("\n");
        for (Map.Entry<String, Set<String>> entry : accMap.entrySet()) {
            String airlineCode = entry.getKey();
            Set<String> missedCityCodes = entry.getValue();
            for (String cityCode : missedCityCodes) {
                sb.append(airlineCode).append(" - ").append(cityCode).append("\n");
            }
        }
        return sb.toString();
    }
}

