/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.complementBooking.getFlightDetails;

import com.gridnine.xtrip.common.gds.sirena2000.SirenaHelper;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.server.gds.sirena2000.model.RaceInfoAnswer;
import com.gridnine.xtrip.server.gds.sirena2000.pricingRoute.PricingRouteHelper;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class FlightDetailsCache {
    private static final String IBUS_CONTEXT_KEY = FlightDetailsCache.class.getName();
    private final Map<List<String>, RaceInfoAnswer.Navigation> data = new HashMap<List<String>, RaceInfoAnswer.Navigation>();

    FlightDetailsCache() {
    }

    static FlightDetailsCache get(MessageContext ctx) {
        FlightDetailsCache cache = (FlightDetailsCache)ctx.getObject(IBUS_CONTEXT_KEY);
        if (cache == null) {
            cache = new FlightDetailsCache();
            ctx.putObject(IBUS_CONTEXT_KEY, (Object)cache);
        }
        return cache;
    }

    private static List<String> buildKey(Segment segment) {
        return Stream.of(SirenaHelper.getNativeCode((DictionaryReference)segment.getAirline()), segment.getFlightNo(), PricingRouteHelper.DF.format(segment.getStartDate())).collect(Collectors.toList());
    }

    RaceInfoAnswer.Navigation getValue(Segment segment) {
        return this.data.get(FlightDetailsCache.buildKey(segment));
    }

    void setValue(Segment segment, RaceInfoAnswer.Navigation value) {
        this.data.put(FlightDetailsCache.buildKey(segment), value);
    }
}

